/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.ConfigurableIssueCodesProvider;
import org.eclipse.xtext.xbase.validation.XbaseSeverityConverter;

@Singleton
public class XbaseConfigurableIssueCodes
extends ConfigurableIssueCodesProvider {
    public static final String JDT_CORE_PLUGIN_ID = "org.eclipse.jdt.core";
    public static final String COMPILER_PB_DISCOURAGED_REFERENCE = "org.eclipse.jdt.core.compiler.problem.discouragedReference";
    public static final String COMPILER_PB_FORBIDDEN_REFERENCE = "org.eclipse.jdt.core.compiler.problem.forbiddenReference";
    public static final String COMPILER_PB_UNNECESSARY_TYPE_CHECK = "org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck";
    public static final String COMPILER_PB_UNUSED_IMPORT = "org.eclipse.jdt.core.compiler.problem.unusedImport";
    public static final String COMPILER_PB_UNUSED_LOCAL = "org.eclipse.jdt.core.compiler.problem.unusedLocal";
    public static final String COMPILER_PB_DEPRECATION = "org.eclipse.jdt.core.compiler.problem.deprecation";
    private Map<String, PreferenceKey> issueCodes;

    public XbaseConfigurableIssueCodes() {
        final LinkedHashMap map = Maps.newLinkedHashMap();
        this.initialize(new IAcceptor<PreferenceKey>(){

            public void accept(PreferenceKey prefKey) {
                map.put(prefKey.getId(), prefKey);
            }
        });
        this.issueCodes = ImmutableMap.copyOf((Map)map);
    }

    protected void initialize(IAcceptor<PreferenceKey> iAcceptor) {
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive_valued_feature", "warning"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception", "ignore"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.equals_with_null", "ignore"));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference", COMPILER_PB_FORBIDDEN_REFERENCE));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.discouraged_reference", COMPILER_PB_DISCOURAGED_REFERENCE));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.import_wildcard_deprecated", "warning"));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_instanceof", COMPILER_PB_UNNECESSARY_TYPE_CHECK));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_cast", COMPILER_PB_UNNECESSARY_TYPE_CHECK));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.import_unsued", COMPILER_PB_UNUSED_IMPORT));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.unused_local_variable", COMPILER_PB_UNUSED_LOCAL));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.import_duplicate", "warning"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_discouraged", "warning"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.import_unresolved", "error"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.java_style_type_cast", "error"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.suspiciously_overloaded_feature", "warning"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.constant_condition", "warning"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_case", "error"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_instance_of", "error"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.incomplete_cases_on_enum", "warning"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.operation_without_parentheses", "ignore"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.builder.copyJavaProblems", "ignore"));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference", COMPILER_PB_DEPRECATION));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type", "error"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.unqualified_super_call", this.getUnqualifiedSuperCallSeverity()));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.abstract_method_invocation", this.getAbstractMethodInvocationSeverity()));
    }

    protected String getUnqualifiedSuperCallSeverity() {
        return "ignore";
    }

    protected String getAbstractMethodInvocationSeverity() {
        return "ignore";
    }

    protected final PreferenceKey create(String id, String defaultValue) {
        return new PreferenceKey(id, defaultValue);
    }

    protected PreferenceKey createDelegate(String id, String delegationKey) {
        return this.createDelegate(id, delegationKey, "warning");
    }

    protected PreferenceKey createDelegate(String id, String delegationKey, String defaultSeverity) {
        String encodedDelegation = XbaseSeverityConverter.encodeDefaultSeverity(delegationKey, defaultSeverity);
        return this.create(id, encodedDelegation);
    }

    public Map<String, PreferenceKey> getConfigurableIssueCodes() {
        return this.issueCodes;
    }
}

