/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.AbstractStaticImportsScope;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.ExtensionScopeHelper;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.StaticExtensionFeatureDescription;
import org.eclipse.xtext.xbase.scoping.batch.StaticExtensionFeatureDescriptionWithImplicitFirstArgument;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class StaticExtensionImportsScope
extends AbstractStaticImportsScope {
    private final ExtensionScopeHelper helper;
    private final XExpression receiver;
    private final LightweightTypeReference receiverType;
    private final boolean implicit;

    public StaticExtensionImportsScope(IScope parent, IFeatureScopeSession session, XExpression receiver, LightweightTypeReference receiverType, boolean implicit, XAbstractFeatureCall context, OperatorMapping operatorMapping) {
        super(parent, session, context, operatorMapping);
        this.receiver = receiver;
        this.receiverType = receiverType;
        this.implicit = implicit;
        this.helper = new ExtensionScopeHelper(receiverType);
    }

    @Override
    protected List<TypeBucket> getBuckets() {
        return this.getSession().getStaticallyImportedExtensionTypes();
    }

    @Override
    protected List<IEObjectDescription> getAllLocalElements() {
        if (this.receiverType != null && !this.helper.isResolvedReceiverType()) {
            return Collections.emptyList();
        }
        return super.getAllLocalElements();
    }

    @Override
    protected void getAllLocalElements(TypeBucket bucket, JvmDeclaredType type, List<IEObjectDescription> result) {
        Iterable features = type.getAllFeatures();
        for (JvmFeature feature : features) {
            if (!feature.isStatic() || !this.helper.isPossibleExtension(feature) || !this.helper.isMatchingFirstParameterDeepCheck((JvmOperation)feature)) continue;
            this.fastAddDescriptions(feature, bucket, result);
        }
    }

    @Override
    protected void getAllLocalElements(TypeBucket bucket, JvmDeclaredType type, Set<String> restrictedNames, List<IEObjectDescription> result) {
        Iterable features = type.getAllFeatures();
        for (JvmFeature feature : features) {
            if (!feature.isStatic() || !restrictedNames.contains(feature.getSimpleName()) || !this.helper.isPossibleExtension(feature) || !this.helper.isMatchingFirstParameterDeepCheck((JvmOperation)feature)) continue;
            this.fastAddDescriptions(feature, bucket, result);
        }
    }

    @Override
    protected BucketedEObjectDescription createDescription(QualifiedName name, JvmFeature feature, TypeBucket bucket) {
        if (!this.helper.isPossibleExtension(feature)) {
            return null;
        }
        if (!this.helper.isMatchingFirstParameter((JvmOperation)feature)) {
            return null;
        }
        return this.doCreateDescription(name, feature, bucket);
    }

    protected BucketedEObjectDescription doCreateDescription(QualifiedName name, JvmFeature feature, TypeBucket bucket) {
        if (this.implicit) {
            return new StaticExtensionFeatureDescriptionWithImplicitFirstArgument(name, feature, this.receiver, this.receiverType, bucket.getId(), this.getSession().isVisible((JvmMember)feature));
        }
        return new StaticExtensionFeatureDescription(name, feature, this.receiver, this.receiverType, bucket.getId(), this.getSession().isVisible((JvmMember)feature));
    }

    protected void fastAddDescriptions(JvmFeature feature, TypeBucket bucket, List<IEObjectDescription> result) {
        QualifiedName operator;
        String simpleName = feature.getSimpleName();
        QualifiedName featureName = QualifiedName.create((String)simpleName);
        BucketedEObjectDescription description = this.doCreateDescription(featureName, feature, bucket);
        this.addToList(description, result);
        String propertyName = this.toProperty(simpleName, feature);
        if (propertyName != null) {
            this.addToList(this.doCreateDescription(QualifiedName.create((String)propertyName), feature, bucket), result);
        }
        if (!this.implicit && (operator = this.getOperatorMapping().getOperator(featureName)) != null) {
            this.addToList(this.doCreateDescription(operator, feature, bucket), result);
        }
    }

    @Override
    protected void addDescriptions(JvmFeature feature, TypeBucket bucket, List<IEObjectDescription> result) {
        String simpleName = feature.getSimpleName();
        QualifiedName featureName = QualifiedName.create((String)simpleName);
        BucketedEObjectDescription description = this.createDescription(featureName, feature, bucket);
        if (description != null) {
            QualifiedName operator;
            this.addToList(description, result);
            String propertyName = this.toProperty(simpleName, feature);
            if (propertyName != null) {
                this.addToList(this.doCreateDescription(QualifiedName.create((String)propertyName), feature, bucket), result);
            }
            if (!this.implicit && (operator = this.getOperatorMapping().getOperator(featureName)) != null) {
                this.addToList(this.doCreateDescription(operator, feature, bucket), result);
            }
        }
    }

    @Override
    protected String toProperty(String methodName, JvmFeature feature) {
        return this.toProperty(methodName, feature, 1, 2);
    }
}

