/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xtype.XImportSection;

public class ImportSectionRegionUtil {
    private static final Logger LOG = Logger.getLogger(ImportSectionRegionUtil.class);
    @Inject
    private IImportsConfiguration config;

    public ITextRegion computeRegion(XtextResource resource) {
        XImportSection xImportSection = this.config.getImportSection(resource);
        if (xImportSection != null) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)xImportSection);
            if (node == null) {
                LOG.error((Object)"Cannot detect node for original import section");
            } else {
                return node.getTextRegion();
            }
        }
        return new TextRegion(this.config.getImportSectionOffset(resource), 0);
    }

    public ITextRegion addLeadingWhitespace(ITextRegion textRegion, XtextResource resource) {
        String text = resource.getParseResult().getRootNode().getText();
        int offset = textRegion.getOffset();
        int length = textRegion.getLength();
        while (offset > 0 && Character.isWhitespace(text.charAt(offset - 1))) {
            --offset;
            ++length;
        }
        return new TextRegion(offset, length);
    }

    public ITextRegion addTrailingWhitespace(ITextRegion textRegion, XtextResource resource) {
        String text = resource.getParseResult().getRootNode().getText();
        int offset = textRegion.getOffset();
        int length = textRegion.getLength();
        while (offset + length < text.length() && Character.isWhitespace(text.charAt(offset + length))) {
            ++length;
        }
        return new TextRegion(offset, length);
    }

    public ITextRegion addTrailingSingleWhitespace(ITextRegion textRegion, String lineSeparator, XtextResource resource) {
        String text = resource.getParseResult().getRootNode().getText();
        String theFollowing = text.substring(textRegion.getOffset() + textRegion.getLength());
        if (!Strings.isEmpty((String)theFollowing)) {
            if (theFollowing.startsWith(lineSeparator)) {
                return new TextRegion(textRegion.getOffset(), textRegion.getLength() + lineSeparator.length());
            }
            if (Character.isWhitespace(theFollowing.charAt(0))) {
                return new TextRegion(textRegion.getOffset(), textRegion.getLength() + 1);
            }
        }
        return textRegion;
    }
}

