/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.semanticHighlight;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SemanticHighlightingCapabilities;
import org.eclipse.lsp4j.SemanticHighlightingInformation;
import org.eclipse.lsp4j.SemanticHighlightingParams;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.util.SemanticHighlightingTokens;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.MergingHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.ide.server.semanticHighlight.ISemanticHighlightingStyleToTokenMapper;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Deprecated
public class SemanticHighlightingRegistry {
    public static final String UNKNOWN_SCOPE = "unknown.xtext";
    public static final List<String> UNKNOWN_SCOPES = Collections.singletonList("unknown.xtext");
    @Inject
    private UriExtensions uriExtensions;
    protected BiMap<Integer, List<String>> scopes;
    protected LanguageClient client;

    public void initialize(Iterable<? extends IResourceServiceProvider> allLanguages, ClientCapabilities capabilities, LanguageClient client) {
        Preconditions.checkState((this.client == null ? 1 : 0) != 0, (Object)"Already initialized.");
        TextDocumentClientCapabilities textDocument = capabilities == null ? null : capabilities.getTextDocument();
        SemanticHighlightingCapabilities semanticHighlightingCapabilities = textDocument == null ? null : textDocument.getSemanticHighlightingCapabilities();
        boolean semanticHighlighting = semanticHighlightingCapabilities == null ? false : semanticHighlightingCapabilities.getSemanticHighlighting();
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        if (semanticHighlighting) {
            Set allScopes = Streams.stream(allLanguages).map(l -> (ISemanticHighlightingStyleToTokenMapper)l.get(ISemanticHighlightingStyleToTokenMapper.class)).filter(m -> m != null).flatMap(mapper -> mapper.getAllStyleIds().stream().map(id -> mapper.toScopes((String)id))).filter(l -> l != null && !l.isEmpty()).collect(Collectors.toSet());
            int i = 0;
            for (List scopes : allScopes) {
                builder.put((Object)i++, (Object)scopes);
            }
        }
        this.scopes = builder.build();
        this.client = client;
    }

    public List<String> getScopes(int scopeIndex) {
        this.checkInitialized();
        return (List)this.scopes.getOrDefault((Object)scopeIndex, UNKNOWN_SCOPES);
    }

    public int getIndex(List<String> scopes) {
        this.checkInitialized();
        if (this.isNullOrUnknown(scopes)) {
            return -1;
        }
        Integer index = (Integer)this.scopes.inverse().get(scopes);
        return index == null ? -1 : index;
    }

    public List<List<String>> getAllScopes() {
        this.checkInitialized();
        ImmutableList.Builder builder = ImmutableList.builder();
        this.scopes.keySet().forEach(it -> builder.add(Preconditions.checkNotNull((Object)this.scopes.get(it), (Object)("No scopes are available for index: " + it))));
        return builder.build();
    }

    public void update(ILanguageServerAccess.Context context) {
        ISemanticHighlightingStyleToTokenMapper mapper;
        this.checkInitialized();
        if (!(context.getResource() instanceof XtextResource)) {
            return;
        }
        if (!context.isDocumentOpen()) {
            return;
        }
        XtextResource resource = (XtextResource)context.getResource();
        IResourceServiceProvider resourceServiceProvider = resource.getResourceServiceProvider();
        ISemanticHighlightingCalculator calculator = resourceServiceProvider == null ? null : (ISemanticHighlightingCalculator)resourceServiceProvider.get(ISemanticHighlightingCalculator.class);
        ISemanticHighlightingStyleToTokenMapper iSemanticHighlightingStyleToTokenMapper = mapper = resourceServiceProvider == null ? null : (ISemanticHighlightingStyleToTokenMapper)resourceServiceProvider.get(ISemanticHighlightingStyleToTokenMapper.class);
        if (calculator == null || this.isIgnoredMapper(mapper)) {
            return;
        }
        Document document = context.getDocument();
        MergingHighlightedPositionAcceptor acceptor = new MergingHighlightedPositionAcceptor(calculator);
        calculator.provideHighlightingFor(resource, acceptor, CancelIndicator.NullImpl);
        Iterable ranges = Iterables.concat((Iterable)Lists.transform(acceptor.getPositions(), position -> Lists.transform(Arrays.asList(position.getIds()), id -> {
            Position start = document.getPosition(position.getOffset());
            Position end = document.getPosition(position.getOffset() + position.getLength());
            int scope = this.getIndex(mapper.toScopes((String)id));
            return new HighlightedRange(start, end, scope);
        })));
        this.notifyClient(new SemanticHighlightingParams(this.toVersionedTextDocumentIdentifier(context), this.toSemanticHighlightingInformation(ranges, document)));
    }

    protected boolean isIgnoredMapper(ISemanticHighlightingStyleToTokenMapper mapper) {
        return mapper instanceof ISemanticHighlightingStyleToTokenMapper.Noop;
    }

    protected List<SemanticHighlightingInformation> toSemanticHighlightingInformation(Iterable<? extends HighlightedRange> ranges, Document document) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        Iterables.filter(ranges, it -> !Objects.equals(it.getStart(), it.getEnd())).forEach(it -> {
            int endLine;
            int startLine = it.getStart().getLine();
            if (startLine == (endLine = it.getEnd().getLine())) {
                int length = it.getEnd().getCharacter() - it.getStart().getCharacter();
                builder.put((Object)startLine, (Object)new SemanticHighlightingTokens.Token(it.getStart().getCharacter(), length, ((HighlightedRange)it).scope));
            } else {
                String startLineContent = document.getLineContent(startLine);
                int startLength = startLineContent.length() - it.getStart().getCharacter();
                builder.put((Object)startLine, (Object)new SemanticHighlightingTokens.Token(it.getStart().getCharacter(), startLength, ((HighlightedRange)it).scope));
                for (int line = startLine + 1; line < endLine; ++line) {
                    String lineContent = document.getLineContent(line);
                    builder.put((Object)line, (Object)new SemanticHighlightingTokens.Token(0, lineContent.length(), ((HighlightedRange)it).scope));
                }
                builder.put((Object)endLine, (Object)new SemanticHighlightingTokens.Token(0, it.getEnd().getCharacter(), ((HighlightedRange)it).scope));
            }
        });
        return this.appendEmptyLineTokens(IterableExtensions.toList((Iterable)Iterables.transform((Iterable)builder.build().asMap().entrySet(), it -> new SemanticHighlightingInformation(((Integer)it.getKey()).intValue(), SemanticHighlightingTokens.encode((Iterable)((Iterable)it.getValue()))))), document);
    }

    protected List<SemanticHighlightingInformation> appendEmptyLineTokens(List<SemanticHighlightingInformation> infos, Document document) {
        int lineCount = document.getLineCount();
        HashMap<Integer, SemanticHighlightingInformation> tokens = new HashMap<Integer, SemanticHighlightingInformation>((Map<Integer, SemanticHighlightingInformation>)Maps.uniqueIndex(infos, it -> it.getLine()));
        for (int i = 0; i < lineCount; ++i) {
            tokens.putIfAbsent(i, new SemanticHighlightingInformation(i, null));
        }
        return new ArrayList<SemanticHighlightingInformation>(tokens.values());
    }

    protected VersionedTextDocumentIdentifier toVersionedTextDocumentIdentifier(ILanguageServerAccess.Context context) {
        VersionedTextDocumentIdentifier id = new VersionedTextDocumentIdentifier();
        id.setUri(this.uriExtensions.toUriString(context.getResource().getURI()));
        id.setVersion(context.getDocument().getVersion());
        return id;
    }

    protected void notifyClient(SemanticHighlightingParams params) {
        this.client.semanticHighlighting(params);
    }

    protected void checkInitialized() {
        Preconditions.checkState((this.client != null ? 1 : 0) != 0, (Object)"Not initialized.");
    }

    protected boolean isNullOrUnknown(List<String> nullable) {
        return UNKNOWN_SCOPES.equals(nullable);
    }

    public static class HighlightedRange
    extends Range {
        private final int scope;

        public HighlightedRange(Position start, Position end, int scope) {
            super(start, end);
            this.scope = scope;
        }

        public int hashCode() {
            return 31 * super.hashCode() + this.scope;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            HighlightedRange other = (HighlightedRange)((Object)obj);
            return other.scope == this.scope;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).addAllFields().toString();
        }

        public int getScope() {
            return this.scope;
        }
    }
}

