/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.impl;

import com.google.common.collect.Lists;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElementAndSyntaxError;
import org.eclipse.xtext.nodemodel.impl.LeafNode;
import org.eclipse.xtext.nodemodel.serialization.DeserializationConversionContext;

public class RootNode
extends CompositeNodeWithSemanticElementAndSyntaxError {
    private String completeContent;
    private int[] lineBreakOffsets;

    @Override
    public CompositeNode getParent() {
        return null;
    }

    @Override
    public ICompositeNode getRootNode() {
        return this;
    }

    @Override
    public int getTotalOffset() {
        return 0;
    }

    @Override
    public int getTotalLength() {
        return this.getCompleteContent().length();
    }

    @Override
    public String getText() {
        return this.getCompleteContent();
    }

    public int getIndex() {
        return 0;
    }

    protected void basicSetCompleteContent(String completeContent) {
        this.completeContent = completeContent;
        this.lineBreakOffsets = this.computeLineBreaks(completeContent);
    }

    protected int[] basicGetLineBreakOffsets() {
        return this.lineBreakOffsets;
    }

    public String getCompleteContent() {
        return this.completeContent;
    }

    @Override
    public INode getNextSibling() {
        return null;
    }

    @Override
    public INode getPreviousSibling() {
        return null;
    }

    @Override
    protected AbstractNode basicGetNextSibling() {
        return this;
    }

    @Override
    protected AbstractNode basicGetPreviousSibling() {
        return this;
    }

    @Override
    protected boolean basicHasPreviousSibling() {
        return false;
    }

    @Override
    protected boolean basicHasNextSibling() {
        return false;
    }

    @Override
    public boolean hasPreviousSibling() {
        return false;
    }

    @Override
    public boolean hasNextSibling() {
        return false;
    }

    @Override
    public boolean hasSiblings() {
        return false;
    }

    @Override
    protected void basicSetNextSibling(AbstractNode next) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void basicSetPreviousSibling(AbstractNode prev) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void basicSetParent(CompositeNode parent) {
        throw new UnsupportedOperationException();
    }

    protected int[] computeLineBreaks(String text) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)50);
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch == '\r') {
                list.add(i);
                if (i + 1 < length && text.charAt(i + 1) == '\n') {
                    ++i;
                }
            } else if (ch == '\n') {
                list.add(i);
            }
            ++i;
        }
        int[] result = new int[list.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (Integer)list.get(i2);
            ++i2;
        }
        return result;
    }

    @Override
    void readData(DataInputStream in, DeserializationConversionContext context) throws IOException {
        super.readData(in, context);
        this.basicSetCompleteContent(context.getCompleteContent());
        int totalLength = this.fixupOffsets(this, 0);
        if (totalLength != this.getCompleteContent().length()) {
            throw new IllegalStateException("The length of the resource's content was " + this.getCompleteContent().length() + " but the length calculated based upon the serialized form of the RootNode was " + totalLength);
        }
    }

    private int fixupOffsets(INode node, int nodeOffset) {
        if (node instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)node;
            leafNode.basicSetTotalOffset(nodeOffset);
            return leafNode.getTotalLength() + nodeOffset;
        }
        if (node instanceof CompositeNode) {
            CompositeNode compositeNode = (CompositeNode)node;
            int currentOffset = nodeOffset;
            AbstractNode firstChild = compositeNode.basicGetFirstChild();
            if (firstChild != null) {
                AbstractNode it = firstChild;
                do {
                    currentOffset = this.fixupOffsets(it, currentOffset);
                } while ((it = it.basicGetNextSibling()) != firstChild);
            }
            return currentOffset;
        }
        return 0;
    }

    @Override
    AbstractNode.NodeType getNodeId() {
        return AbstractNode.NodeType.RootNode;
    }

    public void fillGrammarElementToIdMap(Map<EObject, Integer> grammarElementToIdMap, List<String> grammarIdToURIMap) {
        this.fillGrammarElementToIdMap(0, grammarElementToIdMap, grammarIdToURIMap);
    }
}

