/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IChangeRedirector;
import org.eclipse.xtext.ui.refactoring.IDependentElementsCalculator;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.IRenamedElementTracker;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameProcessor;
import org.eclipse.xtext.ui.refactoring.impl.CachingResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.impl.ReferenceUpdaterDispatcher;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;

public class RenameElementProcessor
extends AbstractRenameProcessor {
    protected static final Logger LOG = Logger.getLogger(RenameElementProcessor.class);
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;
    @Inject
    private IDependentElementsCalculator dependentElementsCalculator;
    @Inject
    private IRenameStrategy.Provider strategyProvider;
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private ReferenceUpdaterDispatcher referenceUpdaterDispatcher;
    @Inject
    private IRenamedElementTracker renameElementTracker;
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject
    private Provider<StatusWrapper> statusProvider;
    private StatusWrapper status;
    private IRenameElementContext renameElementContext;
    private RefactoringResourceSetProvider resourceSets;
    private ResourceSet resourceSet;
    private URI targetElementURI;
    private EObject targetElement;
    private IRenameStrategy renameStrategy;
    private String newName;
    @Inject
    private Provider<IRefactoringUpdateAcceptor> updateAcceptorProvider;
    private ElementRenameArguments renameArguments;
    private IRefactoringUpdateAcceptor currentUpdateAcceptor;

    @Override
    public boolean initialize(IRenameElementContext renameElementContext) {
        try {
            this.status = (StatusWrapper)this.statusProvider.get();
            this.resourceSets = new CachingResourceSetProvider(this.resourceSetProvider);
            this.renameElementContext = renameElementContext;
            this.targetElementURI = renameElementContext.getTargetElementURI();
            this.resourceSet = this.getResourceSet(renameElementContext);
            if (this.resourceSet != null) {
                this.targetElement = this.resourceSet.getEObject(this.targetElementURI, true);
                if (this.targetElement == null) {
                    this.status.add(4, "Rename target element {0} can not be resolved", this.targetElementURI);
                } else {
                    this.renameStrategy = this.createRenameElementStrategy(this.targetElement, renameElementContext);
                    if (this.renameStrategy == null) {
                        return false;
                    }
                }
            }
        }
        catch (IRenameStrategy.Provider.NoSuchStrategyException e) {
            this.status.add(4, e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            this.handleException(e, this.status);
            throw e instanceof RuntimeException ? (RuntimeException)e : new WrappedException(e);
        }
        return true;
    }

    protected ResourceSet getResourceSet(IRenameElementContext renameElementContext) {
        if (this.resourceSet == null) {
            this.resourceSet = this.createResourceSet(renameElementContext);
        }
        return this.resourceSet;
    }

    protected ResourceSet createResourceSet(IRenameElementContext renameElementContext) {
        IProject project = this.projectUtil.getProject(renameElementContext.getTargetElementURI());
        if (project == null) {
            this.status.add(4, "Could not find project for ", renameElementContext.getTargetElementURI());
            return null;
        }
        this.resourceSet = this.resourceSets.get(project);
        return this.resourceSet;
    }

    protected boolean isValidTargetFile(Resource resource, StatusWrapper status) {
        IFile targetFile = this.projectUtil.findFileStorage(resource.getURI(), true);
        if (targetFile != null) {
            return true;
        }
        String path = resource.getURI().isPlatformResource() ? resource.getURI().toPlatformString(true) : resource.getURI().toString();
        status.add(4, "Rename target file '" + path + "' cannot be accessed", resource.getURI());
        return false;
    }

    protected IRenameStrategy createRenameElementStrategy(EObject targetElement, IRenameElementContext renameElementContext) throws IRenameStrategy.Provider.NoSuchStrategyException {
        IRenameStrategy result = this.strategyProvider.get(targetElement, renameElementContext);
        return result;
    }

    public IRenameStrategy getRenameElementStrategy() {
        return this.renameStrategy;
    }

    public Object[] getElements() {
        return new Object[]{this.targetElementURI};
    }

    @Override
    public String getOriginalName() {
        return this.renameStrategy.getOriginalName();
    }

    @Override
    public RefactoringStatus validateNewName(String newName) {
        return this.renameStrategy.validateNewName(newName);
    }

    protected String getLanguageName() {
        return this.languageName;
    }

    public String getIdentifier() {
        return String.valueOf(this.getLanguageName()) + ".ui.refactoring.Processor";
    }

    public String getProcessorName() {
        return "Rename element";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    @Override
    public void setNewName(String newName) {
        this.newName = newName;
    }

    @Override
    public String getNewName() {
        return this.newName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.isValidTargetFile(this.targetElement.eResource(), this.status);
        if (!this.status.getRefactoringStatus().hasFatalError()) {
            this.status.merge(this.validateNewName(this.newName));
        }
        return this.status.getRefactoringStatus();
    }

    protected Iterable<URI> getElementURIs() {
        ArrayList elementURIs = Lists.newArrayList();
        Object[] objectArray = this.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof URI) {
                elementURIs.add((URI)element);
            }
            ++n2;
        }
        return elementURIs;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.status = (StatusWrapper)this.statusProvider.get();
        try {
            this.currentUpdateAcceptor = (IRefactoringUpdateAcceptor)this.updateAcceptorProvider.get();
            this.transferChangeRedirector(this.currentUpdateAcceptor);
            Iterable<URI> dependentElementURIs = this.dependentElementsCalculator.getDependentElementURIs(this.targetElement, (IProgressMonitor)progress.newChild(1));
            Map<URI, URI> original2newElementURIs = this.renameElementTracker.renameAndTrack(Iterables.concat(this.getElementURIs(), dependentElementURIs), this.newName, this.resourceSet, this.renameStrategy, (IProgressMonitor)progress.newChild(1));
            this.renameStrategy.createDeclarationUpdates(this.newName, this.resourceSet, this.currentUpdateAcceptor);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.renameArguments = new ElementRenameArguments(this.targetElementURI, this.newName, this.renameStrategy, original2newElementURIs, this.resourceSets);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.referenceUpdaterDispatcher.createReferenceUpdates(this.renameArguments, this.resourceSet, this.currentUpdateAcceptor, (IProgressMonitor)progress.newChild(98));
            this.status.merge(this.currentUpdateAcceptor.getRefactoringStatus());
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception exc) {
            this.handleException(exc, this.status);
        }
        return this.status.getRefactoringStatus();
    }

    protected void transferChangeRedirector(IRefactoringUpdateAcceptor currentUpdateAcceptor2) {
        if (this.currentUpdateAcceptor instanceof IChangeRedirector.Aware && this.renameElementContext instanceof IChangeRedirector.Aware) {
            ((IChangeRedirector.Aware)((Object)this.currentUpdateAcceptor)).setChangeRedirector(((IChangeRedirector.Aware)((Object)this.getRenameElementContext())).getChangeRedirector());
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return this.currentUpdateAcceptor.createCompositeChange("Rename " + this.renameStrategy.getOriginalName() + " to " + this.newName, monitor);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RenameParticipant[] renameParticipants = ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.renameElementContext, (RenameArguments)new RenameArguments(this.newName, true), (String[])new String[]{"org.eclipse.xtext.ui.shared.xtextNature"}, (SharableParticipants)sharedParticipants);
        return renameParticipants;
    }

    protected void handleException(Exception exc, StatusWrapper status) {
        status.add(4, "Error during refactoring: {0}", exc, LOG);
    }

    public IRenameElementContext getRenameElementContext() {
        return this.renameElementContext;
    }

    protected RefactoringResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    protected ElementRenameArguments getRenameArguments() {
        return this.renameArguments;
    }

    protected EObject getTargetElement() {
        return this.targetElement;
    }

    public Provider<StatusWrapper> getStatusProvider() {
        return this.statusProvider;
    }
}

