/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.editor.ModelSetServiceFactory;
import org.eclipse.papyrus.infra.core.resource.EditingDomainServiceFactory;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelsReader;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceStartKind;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.tools.util.Iterators2;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;

public class ModelResourceMapper<T extends EObject> {
    private final IContainer container;

    public ModelResourceMapper(IContainer container) {
        this.container = container;
    }

    public <R extends ResourceSet> ListMultimap<IFile, T> map(Predicate<? super IFile> filePredicate, Function<? super URI, ? extends R> resourceSetFunction, Function<? super R, ? extends Stream<? extends T>> modelExtractor) {
        ModelVisitor<R> visitor = new ModelVisitor<R>(filePredicate, resourceSetFunction, modelExtractor);
        try {
            this.container.accept(visitor, 2, true);
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return visitor.getMap();
    }

    public static Predicate<IResource> byExtension(String extension) {
        return file -> extension.equals(file.getFileExtension());
    }

    public static Predicate<IResource> byContentType(String contentTypeID) {
        return file -> file.getType() == 1 && ModelResourceMapper.hasContentType((IFile)file, contentTypeID);
    }

    private static boolean hasContentType(IFile file, String contentTypeID) {
        IContentType match = Platform.getContentTypeManager().getContentType(contentTypeID);
        IContentType actual = null;
        try {
            IContentDescription description = file.getContentDescription();
            actual = description != null ? description.getContentType() : null;
        }
        catch (CoreException e) {
            Activator.log.error("Failed to determine content type of model file.", (Throwable)e);
        }
        return match != null && actual != null && actual.isKindOf(match);
    }

    public static Function<URI, ResourceSet> resourceSets() {
        return ModelResourceMapper.resourceSets(null);
    }

    public static Function<URI, ResourceSet> resourceSets(EPackage.Registry packageRegistry) {
        return uri -> ModelResourceMapper.createResourceSet(uri, packageRegistry);
    }

    private static ResourceSet createResourceSet(URI uri, EPackage.Registry packageRegistry) {
        ResourceSetImpl result = new ResourceSetImpl();
        result.setURIConverter(ResourceUtils.createWorkspaceAwareURIConverter());
        if (packageRegistry != null) {
            result.setPackageRegistry(packageRegistry);
        }
        result.getResource(uri, true);
        return result;
    }

    public static Function<URI, ModelSet> modelSets() {
        return ModelResourceMapper::createModelSet;
    }

    private static ModelSet createModelSet(URI uri) {
        ExtensionServicesRegistry service = null;
        try {
            service = new ExtensionServicesRegistry();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
        ServiceDescriptor descriptor = new ServiceDescriptor(ModelSet.class, ModelSetServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10);
        descriptor.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        service.add(descriptor);
        descriptor = new ServiceDescriptor(TransactionalEditingDomain.class, EditingDomainServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10, Collections.singletonList(ModelSet.class.getName()));
        descriptor.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        service.add(descriptor);
        try {
            service.startServicesByClassKeys(new Class[]{ModelSet.class, TransactionalEditingDomain.class});
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        ModelSet modelSet = null;
        try {
            modelSet = ServiceUtils.getInstance().getModelSet((Object)service);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (modelSet == null) {
            modelSet = new ModelSet();
            try {
                ModelSetServiceFactory.setServiceRegistry((ResourceSet)modelSet, (ServicesRegistry)service);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        modelSet.setURIConverter(ResourceUtils.createWorkspaceAwareURIConverter());
        ModelsReader modelsReader = new ModelsReader();
        modelsReader.readModel(modelSet);
        try {
            modelSet.loadModels(uri);
        }
        catch (ModelMultiException e) {
            Activator.log.error((Throwable)e);
        }
        modelSet.getTransactionalEditingDomain();
        return modelSet;
    }

    public static <T extends EObject> Function<ResourceSet, Stream<T>> rootsOfType(Class<? extends T> type) {
        return resourceSet -> Iterators2.stream((TreeIterator)Iterators2.filter(ModelResourceMapper.roots(resourceSet), (Class)type));
    }

    public static <T extends EObject> Function<ResourceSet, Stream<T>> allElementsOfType(Class<? extends T> type) {
        return resourceSet -> Iterators2.stream((TreeIterator)Iterators2.filter((TreeIterator)resourceSet.getAllContents(), (Class)type));
    }

    private static TreeIterator<?> roots(ResourceSet resourceSet) {
        return new AbstractTreeIterator<Object>((Object)resourceSet.getResources(), false){

            protected Iterator<?> getChildren(Object object) {
                return object instanceof Resource ? ((Resource)object).getContents().iterator() : (object instanceof Collection ? ((Collection)object).iterator() : Collections.emptyIterator());
            }
        };
    }

    private final class ModelVisitor<R extends ResourceSet>
    implements IResourceVisitor {
        private final Predicate<? super IFile> filePredicate;
        private final Function<? super URI, ? extends R> resourceSetFunction;
        private final Function<? super R, ? extends Stream<? extends T>> modelExtractor;
        private final ListMultimap<IFile, T> map = ArrayListMultimap.create();

        ModelVisitor(Predicate<? super IFile> filePredicate, Function<? super URI, ? extends R> resourceSetFunction, Function<? super R, ? extends Stream<? extends T>> modelExtractor) {
            this.filePredicate = filePredicate;
            this.resourceSetFunction = resourceSetFunction;
            this.modelExtractor = modelExtractor;
        }

        public boolean visit(IResource resource) throws CoreException {
            IFile file;
            URI uri;
            ResourceSet resourceSet;
            if (resource.getType() == 1 && this.filePredicate.test((IFile)((IFile)resource)) && (resourceSet = (ResourceSet)this.resourceSetFunction.apply((URI)(uri = URI.createPlatformResourceURI((String)(file = (IFile)resource).getFullPath().toString(), (boolean)true)))) != null) {
                try {
                    resourceSet.getResource(uri, true);
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.toolsmiths.validation.common", "Failed to load file " + String.valueOf(file.getFullPath()), (Throwable)e));
                }
                this.modelExtractor.apply(resourceSet).forEach(model -> {
                    boolean bl = this.map.put((Object)file, model);
                });
            }
            return true;
        }

        ListMultimap<IFile, T> getMap() {
            return this.map;
        }
    }
}

