/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.util;

import java.util.function.Function;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.DecoratorAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemProviderDecorator;
import org.eclipse.emf.edit.provider.ItemProviderDecorator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.contexts.UnknownProperty;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.messages.Messages;

public class PropertiesContextDecoratorAdapterFactory
extends DecoratorAdapterFactory {
    public PropertiesContextDecoratorAdapterFactory(AdapterFactory decoratedAdapterFactory) {
        super(decoratedAdapterFactory);
    }

    protected IItemProviderDecorator createItemProviderDecorator(Object target, Object type) {
        return new ContextItemProviderDecorator(this.getDecoratedAdapterFactory());
    }

    private static class ContextItemProviderDecorator
    extends ItemProviderDecorator
    implements Adapter,
    IItemLabelProvider {
        ContextItemProviderDecorator(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getText(Object object) {
            String result = null;
            if (object instanceof DataContextElement || object instanceof Property) {
                result = this.getQualifiedName(object);
            }
            if (result == null) {
                result = super.getText(object);
            }
            if (object instanceof UnknownProperty) {
                result = this.decorateUnknownPropertyText((UnknownProperty)object, result);
            }
            return result;
        }

        String getQualifiedName(Object contextElement) {
            StringBuilder result = new StringBuilder();
            this.qualifiedName(contextElement, result);
            if (result != null) {
                EObject object = (EObject)contextElement;
                String key = String.format("_UI_%s_type", object.eClass().getName());
                String type = ((ResourceLocator)this.getDecoratedItemProvider()).getString(key);
                result.insert(0, " ");
                result.insert(0, type);
            }
            return result == null ? null : result.toString();
        }

        private StringBuilder qualifiedName(Object contextElement, StringBuilder buf) {
            if (contextElement instanceof Property) {
                Property property = (Property)contextElement;
                return this.qualifiedName(property, buf, Property::getContextElement, Property::getName);
            }
            if (contextElement instanceof DataContextElement) {
                DataContextElement element = (DataContextElement)contextElement;
                return this.qualifiedName(element, buf, DataContextElement::getPackage, DataContextElement::getName);
            }
            return null;
        }

        private <T> StringBuilder qualifiedName(T contextElement, StringBuilder buf, Function<? super T, ?> ownerFunction, Function<? super T, String> nameFunction) {
            String name;
            Object owner = ownerFunction.apply(contextElement);
            if (owner != null) {
                this.qualifiedName(owner, buf);
            }
            if (buf == null) {
                return null;
            }
            if (buf.length() > 0) {
                buf.append("::");
            }
            if ((name = nameFunction.apply(contextElement)) == null) {
                return null;
            }
            buf.append(name);
            return buf;
        }

        String decorateUnknownPropertyText(UnknownProperty unknownProperty, String text) {
            URI uri;
            String result = text;
            Resource resource = unknownProperty.eResource();
            URI uRI = uri = resource == null ? null : resource.getURI();
            if (uri != null) {
                result = NLS.bind((String)Messages.PropertiesContextDecoratorAdapterFactory_0, (Object)text, (Object)uri.lastSegment());
            }
            return result;
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }
    }
}

