/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.locators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.composite.custom.figures.LineDecorator;
import org.eclipse.papyrus.uml.diagram.composite.custom.figures.PortFigure;
import org.eclipse.papyrus.uml.diagram.composite.custom.locators.BasePortChildLocator;

public class LineDecoratorLocator
extends BasePortChildLocator {
    public LineDecoratorLocator(PortFigure port) {
        super(port);
    }

    public void relocate(IFigure target) {
        Rectangle portBounds = this.myPort.getBounds();
        int lengthAndWidthCorrection = 1;
        Point start = portBounds.getCenter();
        Point end = new Point();
        LineDecorator ld = (LineDecorator)target;
        int lineWidth = ld.getLineWidth();
        switch (this.getPortSide()) {
            case 8: {
                start.x = start.x + portBounds.width / 2 - 1;
                end.x = start.x + 6;
                start.y = start.y - lineWidth / 2 - lengthAndWidthCorrection;
                end.y = start.y + lineWidth;
                ld.setHorizontal(true);
                break;
            }
            case 16: {
                start.x = start.x - portBounds.width / 2 - 1;
                end.x = start.x - 6;
                start.y = start.y - lineWidth / 2 - lengthAndWidthCorrection;
                end.y = start.y + lineWidth;
                ld.setHorizontal(true);
                break;
            }
            case 4: 
            case 12: 
            case 20: {
                start.y = start.y - portBounds.height / 2 - 1;
                end.y = start.y - 6;
                start.x = start.x - lineWidth / 2 - lengthAndWidthCorrection;
                end.x = start.x + lineWidth;
                ld.setHorizontal(false);
                break;
            }
            case 1: 
            case 9: 
            case 17: {
                start.y = start.y + portBounds.width / 2 - 1;
                end.y = start.y + 6;
                start.x = start.x - lineWidth / 2 - lengthAndWidthCorrection;
                end.x = start.x + lineWidth;
                ld.setHorizontal(false);
                break;
            }
        }
        target.setBounds(new Rectangle(start, end));
    }
}

