/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.validation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.modelrepair.validation.IProfileSwitchPrecondition;
import org.eclipse.papyrus.uml.modelrepair.validation.ProfileSwitchContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ProfileSwitchValidator {
    private static final String EXT_PT = "profileSwitchPreconditions";
    private static final String E_PRECONDITION = "precondition";
    private static final String A_CLASS = "class";
    private final List<IProfileSwitchPrecondition> preconditions = ProfileSwitchValidator.loadPreconditions();

    public boolean validate(final ProfileSwitchContext ctx) {
        final boolean[] result = new boolean[]{true};
        if (!this.preconditions.isEmpty()) {
            ArrayList statuses = Lists.newArrayListWithCapacity((int)this.preconditions.size());
            for (IProfileSwitchPrecondition next : this.preconditions) {
                try {
                    IStatus status = next.validateProfileSwitch(ctx);
                    if (status == null || status.isOK()) continue;
                    statuses.add(status);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in profile switch pre-condition.", (Throwable)e);
                }
            }
            final IStatus status = statuses.isEmpty() ? Status.OK_STATUS : (statuses.size() == 1 ? (IStatus)statuses.get(0) : new MultiStatus("org.eclipse.papyrus.uml.modelrepair", 0, (IStatus[])Iterables.toArray((Iterable)statuses, IStatus.class), "Problems in profile switch initial conditions check.", null));
            switch (status.getSeverity()) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    final ErrorDialog dlg = new ErrorDialog(ctx.getShell(), "Profile Switch", "Profile switch initial conditions check found problems in the model that may cause the switch to fail or be incomplete.  Are you sure you want to proceed?", status, 3){

                        protected void createButtonsForButtonBar(Composite parent) {
                            this.createDetailsButton(parent);
                            this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
                            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
                        }

                        protected void buttonPressed(int id) {
                            switch (id) {
                                case 2: {
                                    this.setReturnCode(0);
                                    this.close();
                                    break;
                                }
                                case 3: {
                                    this.setReturnCode(1);
                                    this.close();
                                    break;
                                }
                                default: {
                                    super.buttonPressed(id);
                                }
                            }
                        }
                    };
                    ctx.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            result[0] = dlg.open() == 0;
                        }
                    });
                    break;
                }
                default: {
                    ctx.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            result[0] = false;
                            ErrorDialog.openError((Shell)ctx.getShell(), (String)"Profile Switch", (String)"Profile switch cannot be performed until problems in the model are corrected.", (IStatus)status);
                        }
                    });
                }
            }
        }
        return result[0];
    }

    private static List<IProfileSwitchPrecondition> loadPreconditions() {
        ArrayList result = Lists.newArrayList();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.uml.modelrepair", EXT_PT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement next = iConfigurationElementArray[n2];
            if (E_PRECONDITION.equals(next.getName())) {
                try {
                    result.add((IProfileSwitchPrecondition)next.createExecutableExtension(A_CLASS));
                }
                catch (Exception e) {
                    Activator.log.error("Invalid profile switch precondition extension in bundle " + next.getContributor().getName(), (Throwable)e);
                }
            }
            ++n2;
        }
        return result;
    }
}

