/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.expression;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.NullEvaluationHandler;

public class LoggingNullEvaluationHandler
implements NullEvaluationHandler {
    private Log log = LogFactory.getLog(LoggingNullEvaluationHandler.class);
    private Level level = Level.ERROR;

    public Object handleNullEvaluation(SyntaxElement element, ExecutionContext ctx) {
        CharSequence msg = null;
        if (this.isLevelEnabled()) {
            msg = this.buildMessage(element, ctx);
        }
        switch (this.level) {
            case FATAL: {
                this.log.fatal((Object)msg);
                break;
            }
            case ERROR: {
                this.log.error((Object)msg);
                break;
            }
            case WARN: {
                this.log.warn((Object)msg);
                break;
            }
            case INFO: {
                this.log.info((Object)msg);
                break;
            }
            case DEBUG: {
                this.log.debug((Object)msg);
                break;
            }
            case TRACE: {
                this.log.trace((Object)msg);
            }
        }
        return null;
    }

    private boolean isLevelEnabled() {
        switch (this.level) {
            case FATAL: {
                return this.log.isFatalEnabled();
            }
            case ERROR: {
                return this.log.isErrorEnabled();
            }
            case WARN: {
                return this.log.isWarnEnabled();
            }
            case INFO: {
                return this.log.isInfoEnabled();
            }
            case DEBUG: {
                return this.log.isDebugEnabled();
            }
            case TRACE: {
                return this.log.isTraceEnabled();
            }
        }
        return false;
    }

    public void setLogCategory(String category) {
        this.log = LogFactory.getLog((String)category);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    protected CharSequence buildMessage(SyntaxElement element, ExecutionContext ctx) {
        StringBuilder msg = new StringBuilder();
        msg.append("null evaluation in ").append(element.getFileName()).append(" on line ").append(element.getLine()).append(" '").append(element).append("'");
        return msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        OFF,
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

