/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.naming;

import java.util.Iterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.gmf.internal.bridge.naming.AbstractNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.NamingStrategy;
import org.eclipse.gmf.internal.common.NamesDispenser;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.NodeMapping;

public class ClassNamingStrategy
extends AbstractNamingStrategy {
    private static final int MAX_SEGMENT_LENGTH = 23;

    public ClassNamingStrategy(String suffix, NamesDispenser namesDispenser, NamingStrategy chainedNamingStrategy, NamingStrategy prefixNamingStrategy) {
        super(suffix, namesDispenser, chainedNamingStrategy, prefixNamingStrategy);
    }

    public String get(CanvasMapping mapping) {
        String name;
        if (mapping.getDomainMetaElement() != null && !this.isEmpty(name = mapping.getDomainMetaElement().getName())) {
            return this.createClassName(name);
        }
        return super.get(mapping);
    }

    public String get(NodeMapping mapping) {
        String name;
        if (mapping.getDomainMetaElement() != null && !this.isEmpty(name = mapping.getDomainMetaElement().getName())) {
            return this.createClassName(name);
        }
        return super.get(mapping);
    }

    public String get(LinkMapping mapping) {
        String name;
        if (mapping.getDomainMetaElement() != null && !this.isEmpty(name = mapping.getDomainMetaElement().getName())) {
            return this.createClassName(name);
        }
        if (mapping.getLinkMetaFeature() != null && !this.isEmpty(name = mapping.getLinkMetaFeature().getName())) {
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
            name = String.valueOf(mapping.getLinkMetaFeature().getEContainingClass().getName()) + name;
            return this.createClassName(name);
        }
        return super.get(mapping);
    }

    public String get(LabelMapping mapping) {
        StringBuffer sb = new StringBuffer();
        Iterator features = mapping.getFeatures().iterator();
        while (features.hasNext()) {
            EAttribute feature = (EAttribute)features.next();
            String name = feature.getName();
            if (this.isEmpty(name)) continue;
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
            sb.append(name);
        }
        if (sb.length() > 0) {
            String name = sb.toString();
            if (name.length() > 23) {
                name = name.substring(0, 23);
            }
            return this.createClassName(String.valueOf(this.getLabelHostPrefix(mapping)) + name);
        }
        return super.get(mapping);
    }
}

