/*******************************************************************************
 * Copyright (c) 2009 - 2010 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class CleanGeneratedAction extends CommandAction implements IEditorActionDelegate {
	
	public CleanGeneratedAction() {
		super("org.eclipse.emf.mint.ui.actions.CleanGeneratedCommand"); //$NON-NLS-1$
	}
	
	@Override
	protected String getExecutionErrorMessage(ExecutionException e) {
		return Messages.CleanGeneratedAction_ExecutionErrorMessage;
	}

	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		setAction(action);
		setPartSite(targetEditor == null ? null : targetEditor.getEditorSite());
	}
}
