/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.views;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.mint.internal.ui.views.ItemJavaElementDescriptor;
import org.eclipse.emf.mint.internal.ui.views.Messages;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;

public class UpdateViewerJob
extends WorkbenchJob {
    private final TableViewer viewer;
    private final IWorkbenchSiteProgressService progressService;
    private final Object updateLock = new Object();
    private LinkedHashMap<ItemJavaElementDescriptor, Object> updates;

    public UpdateViewerJob(TableViewer viewer, IWorkbenchSiteProgressService progressService) {
        super(viewer.getControl().getDisplay(), Messages.UpdateViewerJob_Name);
        this.viewer = viewer;
        this.progressService = progressService;
        this.setSystem(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdate(ItemJavaElementDescriptor descriptor, Object element) {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.updates == null) {
                this.updates = new LinkedHashMap();
            }
            if (!this.updates.containsKey((Object)descriptor)) {
                this.updates.put(descriptor, element);
                if (this.progressService == null) {
                    this.schedule();
                } else {
                    this.progressService.schedule((Job)this, 0L, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus runInUIThread(IProgressMonitor monitor) {
        LinkedHashMap<ItemJavaElementDescriptor, Object> updates;
        if (monitor.isCanceled() || this.viewer.getControl().isDisposed()) {
            return Status.CANCEL_STATUS;
        }
        Object object = this.updateLock;
        synchronized (object) {
            updates = this.updates;
            this.updates = null;
        }
        if (updates != null) {
            for (Map.Entry<ItemJavaElementDescriptor, Object> update : updates.entrySet()) {
                update.getKey().setElement(update.getValue());
            }
            this.viewer.update(updates.keySet().toArray(), null);
            if (this.progressService != null) {
                this.progressService.warnOfContentChange();
            }
        }
        return Status.OK_STATUS;
    }
}

