/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Node;

public class EdgeSourcePropertyDescriptor
extends ItemPropertyDescriptor {
    public EdgeSourcePropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature) {
        super(adapterFactory, resourceLocator, displayName, description, feature, true, false, true, null, null, null);
        this.itemDelegator = new ItemPropertyDescriptor.ItemDelegator(this, adapterFactory, resourceLocator){

            public String getText(Object object) {
                if (object instanceof Node) {
                    Node node = (Node)object;
                    String nodeLabel = node.getName() == null || node.getName().equals("") ? "_" : node.getName();
                    String typeLabel = node.getType() != null ? node.getType().getName() : "_";
                    String nodeContainerLabel = node.getGraph().getName() == null || node.getGraph().getName().equals("") ? "_" : node.getGraph().getName();
                    return String.valueOf(nodeLabel) + ":" + typeLabel + " [" + nodeContainerLabel + "]";
                }
                return super.getText(object);
            }
        };
    }

    protected Collection<?> getComboBoxObjects(Object object) {
        if (object instanceof Edge) {
            Edge edge = (Edge)object;
            Graph graph = edge.getGraph();
            EReference edgeType = edge.getType();
            ArrayList<Node> nodeList = new ArrayList<Node>();
            if (edgeType != null) {
                EClass srcNodeType = (EClass)edgeType.eContainer();
                for (Node node : graph.getNodes()) {
                    if (!node.getType().equals(srcNodeType) && !srcNodeType.isSuperTypeOf(node.getType())) continue;
                    nodeList.add(node);
                }
            } else {
                nodeList.addAll((Collection<Node>)graph.getNodes());
            }
            nodeList.add(null);
            return nodeList;
        }
        return super.getComboBoxObjects(object);
    }
}

