/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.diagram.edit.helpers.HenshinBaseEditHelper;
import org.eclipse.emf.henshin.model.Module;

public class ModuleEditHelper
extends HenshinBaseEditHelper {
    public static EClassifier[] getEClassifiers(Module module, String name) {
        if (name == null) {
            return new EClassifier[0];
        }
        EClassifier result = null;
        String[] names = (name = name.trim()).split("\\.");
        if (names.length > 1) {
            for (EPackage p : ModuleEditHelper.collectAllEPackages(module, true)) {
                if (!p.getName().equals(names[0])) continue;
                result = ModuleEditHelper.getEClassifier(p, names, 1);
                break;
            }
            return new EClassifier[]{result};
        }
        Set<EClassifier> eclassifierList = ModuleEditHelper.collectAllEClassifiers(module, true);
        ArrayList<EClassifier> resultList = new ArrayList<EClassifier>();
        for (EClassifier ec : eclassifierList) {
            if (!ec.getName().equals(name)) continue;
            resultList.add(ec);
        }
        return resultList.toArray(new EClassifier[resultList.size()]);
    }

    private static EClassifier getEClassifier(EPackage epackage, String[] qualifiedName, int index) {
        EClassifier classifier = null;
        if (index < qualifiedName.length - 1) {
            for (EPackage subPackage : epackage.getESubpackages()) {
                if (!subPackage.getName().equals(qualifiedName[index])) continue;
                classifier = ModuleEditHelper.getEClassifier(subPackage, qualifiedName, index + 1);
                break;
            }
        } else {
            classifier = epackage.getEClassifier(qualifiedName[qualifiedName.length - 1]);
        }
        return classifier;
    }

    public static Set<EClassifier> collectAllEClassifiers(Module module, boolean withEcore) {
        LinkedHashSet<EClassifier> classifiers = new LinkedHashSet<EClassifier>();
        for (EPackage p : ModuleEditHelper.collectAllEPackages(module, withEcore)) {
            ModuleEditHelper.collectAllEClassifierHelper(classifiers, p);
        }
        return classifiers;
    }

    public static Set<EClass> collectAllEClasses(Module module, boolean withEcore) {
        Set<EClassifier> classifiers = ModuleEditHelper.collectAllEClassifiers(module, withEcore);
        LinkedHashSet<EClass> classes = new LinkedHashSet<EClass>();
        for (EClassifier classifier : classifiers) {
            if (!(classifier instanceof EClass)) continue;
            classes.add((EClass)classifier);
        }
        return classes;
    }

    private static Set<EPackage> collectAllEPackages(Module module, boolean withEcore) {
        LinkedHashSet<EPackage> packages = new LinkedHashSet<EPackage>();
        packages.addAll((Collection<EPackage>)module.getImports());
        if (withEcore) {
            packages.add((EPackage)EcorePackage.eINSTANCE);
        }
        return packages;
    }

    private static void collectAllEClassifierHelper(Set<EClassifier> elements, EPackage p) {
        elements.addAll((Collection<EClassifier>)p.getEClassifiers());
        for (EPackage p2 : p.getESubpackages()) {
            ModuleEditHelper.collectAllEClassifierHelper(elements, p2);
        }
    }
}

