/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.matching.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.matching.conditions.attribute.AttributeConditionHandler;
import org.eclipse.emf.henshin.matching.conditions.nested.IFormula;
import org.eclipse.emf.henshin.matching.conditions.nested.TrueFormula;
import org.eclipse.emf.henshin.matching.constraints.AttributeConstraint;
import org.eclipse.emf.henshin.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.matching.constraints.Matchfinder;
import org.eclipse.emf.henshin.matching.constraints.ReferenceConstraint;
import org.eclipse.emf.henshin.matching.constraints.Variable;
import org.eclipse.emf.henshin.matching.util.TransformationOptions;

public class GraphIsomorphyChecker {
    private static final TransformationOptions TRANSFORMATION_OPTIONS = new TransformationOptions();
    private static final AttributeConditionHandler ATTRIBUTE_CONDITION_HANDLER;
    private static final IFormula TRUE_FORMULA;
    private final EmfGraph source;
    private int linkCount;
    private final List<EAttribute> ignoredAttributes;
    private Map<EObject, Variable> variablesMap;
    private List<Variable> variablesList;

    static {
        TRANSFORMATION_OPTIONS.setInjective(true);
        TRANSFORMATION_OPTIONS.setDeterministic(true);
        TRANSFORMATION_OPTIONS.setDangling(false);
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
        ATTRIBUTE_CONDITION_HANDLER = new AttributeConditionHandler(new HashMap<String, Collection<String>>(), engine);
        TRUE_FORMULA = new TrueFormula();
    }

    public GraphIsomorphyChecker(EmfGraph source, List<EAttribute> ignoredAttributes) {
        this.source = source;
        this.ignoredAttributes = ignoredAttributes;
        this.linkCount = GraphIsomorphyChecker.computeLinkCount(source);
        this.initVariables();
    }

    private void initVariables() {
        int objectCount = this.source.geteObjects().size();
        this.variablesMap = new HashMap<EObject, Variable>(objectCount);
        this.variablesList = new ArrayList<Variable>(objectCount);
        for (EObject eObject : this.source.geteObjects()) {
            Variable variable = new Variable(eObject.eClass(), true);
            this.variablesMap.put(eObject, variable);
            this.variablesList.add(variable);
        }
        for (Map.Entry entry : this.variablesMap.entrySet()) {
            EObject object = (EObject)entry.getKey();
            Variable variable = (Variable)entry.getValue();
            for (EAttribute attr : object.eClass().getEAllAttributes()) {
                if (this.ignoredAttributes.contains(attr)) continue;
                variable.addConstraint(new AttributeConstraint(attr, object.eGet((EStructuralFeature)attr)));
            }
            for (EReference ref : object.eClass().getEAllReferences()) {
                if (ref.isMany()) {
                    EList targets = (EList)object.eGet((EStructuralFeature)ref);
                    for (EObject target : targets) {
                        variable.addConstraint(new ReferenceConstraint(this.variablesMap.get(target), ref));
                    }
                    continue;
                }
                EObject target = (EObject)object.eGet((EStructuralFeature)ref);
                if (target == null) continue;
                variable.addConstraint(new ReferenceConstraint(this.variablesMap.get(target), ref));
            }
        }
    }

    public boolean isIsomorphicTo(EmfGraph graph, Map<EObject, EObject> preMatch) {
        if (this.source.geteObjects().size() != graph.geteObjects().size()) {
            return false;
        }
        HashMap<Variable, DomainSlot> domainMap = new HashMap<Variable, DomainSlot>();
        for (Map.Entry<EObject, Variable> entry : this.variablesMap.entrySet()) {
            EObject match;
            DomainSlot domainSlot = new DomainSlot(ATTRIBUTE_CONDITION_HANDLER, new HashSet<EObject>(), TRANSFORMATION_OPTIONS);
            if (preMatch != null && (match = preMatch.get(entry.getKey())) != null) {
                domainSlot.fixInstantiation(match);
            }
            domainMap.put(entry.getValue(), domainSlot);
        }
        Matchfinder matchFinder = new Matchfinder(graph, domainMap, ATTRIBUTE_CONDITION_HANDLER);
        matchFinder.setVariables(this.variablesList);
        matchFinder.setFormula(TRUE_FORMULA);
        if (!matchFinder.findSolution()) {
            return false;
        }
        return this.linkCount == GraphIsomorphyChecker.computeLinkCount(graph);
    }

    private static int computeLinkCount(EmfGraph graph) {
        int links = 0;
        for (EObject object : graph.geteObjects()) {
            for (EReference ref : object.eClass().getEAllReferences()) {
                if (ref.isMany()) {
                    links += ((EList)object.eGet((EStructuralFeature)ref)).size();
                    continue;
                }
                if (object.eGet((EStructuralFeature)ref) == null) continue;
                ++links;
            }
        }
        return links;
    }
}

