/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.matching.constraints;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.matching.constraints.UnaryConstraint;

public class TypeConstraint
implements UnaryConstraint {
    EClass type;
    boolean strictTyping;

    public TypeConstraint(EClass type, boolean strictTyping) {
        this.type = type;
        this.strictTyping = strictTyping;
    }

    @Override
    public boolean check(DomainSlot slot) {
        return !slot.locked || this.isValid(slot);
    }

    protected boolean isValid(DomainSlot slot) {
        return this.isValid(slot.value);
    }

    protected boolean isValid(EObject value) {
        return this.strictTyping ? this.type == value.eClass() : this.type.isSuperTypeOf(value.eClass());
    }

    public boolean initDomain(DomainSlot slot, EmfGraph graph) {
        if (slot.domain == null) {
            slot.domain = graph.getDomainForType(this.type, this.strictTyping);
            return !slot.domain.isEmpty();
        }
        if (slot.domain.isEmpty()) {
            return false;
        }
        int i = slot.domain.size() - 1;
        while (i >= 0) {
            EObject eObject = slot.domain.get(i);
            if (eObject == null || !this.isValid(eObject)) {
                slot.domain.remove(i);
            }
            --i;
        }
        return !slot.domain.isEmpty();
    }

    public boolean isStrictTyping() {
        return this.strictTyping;
    }

    public boolean instantiationPossible(DomainSlot slot, EmfGraph graph) {
        return slot.locked ? this.isValid(slot) : !graph.isDomainEmpty(this.type, this.strictTyping);
    }
}

