/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.sierpinski;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.interpreter.util.Match;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class SierpinskiBenchmark {
    public static void main(String[] args) {
        HenshinResourceSet resourceSet = new HenshinResourceSet("src/org/eclipse/emf/henshin/examples/sierpinski/model");
        TransformationSystem trasys = resourceSet.getTransformationSystem("sierpinski.henshin");
        EObject container = resourceSet.getFirstRoot("sierpinski-start.xmi");
        EmfGraph graph = new EmfGraph(new EObject[]{container});
        graph.removeEObject(container);
        EmfEngine engine = new EmfEngine(graph);
        Rule addTriangleRule = trasys.findRuleByName("AddTriangle");
        System.out.println(String.valueOf(Runtime.getRuntime().maxMemory() / 0x100000L) + "MB available memory\n");
        int i = 1;
        while (true) {
            long startTime = System.nanoTime();
            RuleApplication addTriangle = new RuleApplication((InterpreterEngine)engine, addTriangleRule);
            List matches = addTriangle.findAllMatches();
            long matchingTime = (System.nanoTime() - startTime) / 1000000L;
            System.out.println("Level: " + i);
            System.out.println("Rule applications:" + matches.size());
            System.out.println("Matching: " + matchingTime + "ms");
            startTime = System.nanoTime();
            for (Match match : matches) {
                addTriangle = new RuleApplication((InterpreterEngine)engine, addTriangleRule);
                addTriangle.setMatch(match);
                addTriangle.apply();
            }
            long runtime = (System.nanoTime() - startTime) / 1000000L;
            System.out.println("Application: " + runtime + "ms");
            System.out.println("Total: " + (matchingTime + runtime) + "ms");
            System.out.println("Nodes: " + graph.geteObjects().size());
            System.out.println();
            ++i;
        }
    }
}

