/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions.internal;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.Action;
import org.eclipse.emf.henshin.model.actions.ActionType;
import org.eclipse.emf.henshin.model.actions.HenshinActionHelper;
import org.eclipse.emf.henshin.model.actions.internal.ActionElementFinder;
import org.eclipse.emf.henshin.model.actions.internal.EdgeMapEditor;
import org.eclipse.emf.henshin.model.actions.internal.GenericActionHelper;
import org.eclipse.emf.henshin.model.actions.internal.MapEditor;
import org.eclipse.emf.henshin.model.actions.internal.NodeMapEditor;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;

public class EdgeActionHelper
extends GenericActionHelper<Edge, Rule> {
    public static final EdgeActionHelper INSTANCE = new EdgeActionHelper();

    @Override
    public List<Edge> getActionElements(Rule rule, Action action) {
        List candidates = ActionElementFinder.getRuleElementCandidates(rule, action, HenshinPackage.eINSTANCE.getGraph_Edges());
        return this.filterElementsByAction(candidates, action);
    }

    @Override
    protected MapEditor<Edge> getMapEditor(Graph target) {
        return new EdgeMapEditor(target);
    }

    @Override
    protected MapEditor<Edge> getMapEditor(Graph source, Graph target, List<Mapping> mappings) {
        return new EdgeMapEditor(source, target, mappings);
    }

    public Edge getActionEdge(Edge edge) {
        return ActionElementFinder.getActionElement(edge, INSTANCE);
    }

    public Edge createEdge(Node source, Node target, EReference type) {
        Action trgAction;
        if (!this.canCreateEdge(source, target, type)) {
            return null;
        }
        Rule rule = source.getGraph().getContainerRule();
        Edge edge = null;
        Action srcAction = HenshinActionHelper.getAction(source);
        if (srcAction.equals(trgAction = HenshinActionHelper.getAction(target))) {
            edge = HenshinFactory.eINSTANCE.createEdge(source, target, type);
            if (srcAction.getType() == ActionType.PRESERVE) {
                Node srcImage = HenshinMappingUtil.getNodeImage(source, rule.getRhs(), rule.getMappings());
                Node trgImage = HenshinMappingUtil.getNodeImage(target, rule.getRhs(), rule.getMappings());
                HenshinFactory.eINSTANCE.createEdge(srcImage, trgImage, type);
            }
        } else {
            Graph multiRhs;
            boolean copyToRhs;
            if (EdgeActionHelper.isSimplePreserve(srcAction)) {
                Rule multiRule;
                Node realSource;
                if (trgAction.isAmalgamated() && (realSource = HenshinMappingUtil.getNodeImage(source, (multiRule = target.getGraph().getContainerRule()).getLhs(), multiRule.getMultiMappings())) != null) {
                    source = realSource;
                }
                if (trgAction.getType() == ActionType.CREATE || trgAction.getType() == ActionType.FORBID || trgAction.getType() == ActionType.REQUIRE) {
                    source = new NodeMapEditor(target.getGraph()).copy(source);
                }
                copyToRhs = trgAction.isAmalgamated() && trgAction.getType() == ActionType.PRESERVE;
                multiRhs = target.getGraph().getContainerRule().getRhs();
            } else {
                Rule multiRule;
                Node realTarget;
                if (srcAction.isAmalgamated() && (realTarget = HenshinMappingUtil.getNodeImage(target, (multiRule = source.getGraph().getContainerRule()).getLhs(), multiRule.getMultiMappings())) != null) {
                    target = realTarget;
                }
                if (srcAction.getType() == ActionType.CREATE || srcAction.getType() == ActionType.FORBID) {
                    target = new NodeMapEditor(source.getGraph()).copy(target);
                }
                copyToRhs = srcAction.isAmalgamated() && srcAction.getType() == ActionType.PRESERVE;
                multiRhs = source.getGraph().getContainerRule().getRhs();
            }
            edge = HenshinFactory.eINSTANCE.createEdge(source, target, type);
            if (copyToRhs) {
                new EdgeMapEditor(multiRhs).copy(edge);
            }
        }
        return edge;
    }

    public boolean canCreateEdge(Node source, Node target, EReference edgeType) {
        EClass targetType = target.getType();
        EClass sourceType = source.getType();
        if (source == null || target == null || sourceType == null || targetType == null || edgeType == null) {
            return false;
        }
        if (!sourceType.getEAllReferences().contains((Object)edgeType)) {
            return false;
        }
        if (!edgeType.getEReferenceType().isSuperTypeOf(targetType) && !targetType.isSuperTypeOf(edgeType.getEReferenceType()) && edgeType.getEReferenceType() != EcorePackage.eINSTANCE.getEObject()) {
            return false;
        }
        Graph sourceGraph = source.getGraph();
        Graph targetGraph = target.getGraph();
        if (sourceGraph == null || targetGraph == null) {
            return false;
        }
        Rule sourceRule = sourceGraph.getContainerRule();
        Rule targetRule = targetGraph.getContainerRule();
        if (sourceRule == null || targetRule == null) {
            return false;
        }
        if (sourceRule != targetRule && sourceRule != targetRule.getKernelRule() && sourceRule.getKernelRule() != targetRule) {
            return false;
        }
        Action action1 = HenshinActionHelper.getAction(source);
        Action action2 = HenshinActionHelper.getAction(target);
        if (action1 == null || action2 == null) {
            return false;
        }
        return action1.equals(action2) || EdgeActionHelper.isSimplePreserve(action1) || EdgeActionHelper.isSimplePreserve(action2);
    }

    private static boolean isSimplePreserve(Action action) {
        return action.getType() == ActionType.PRESERVE && !action.isAmalgamated() && action.getArguments().length == 0;
    }
}

