/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions.internal;

import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.Action;
import org.eclipse.emf.henshin.model.actions.ActionType;
import org.eclipse.emf.henshin.model.util.HenshinACUtil;

public class ActionACUtil {
    public static final String DEFAULT_AC_NAME = "default";

    public static NestedCondition getOrCreateAC(Action action, Rule rule) {
        NestedCondition ac;
        if (action == null || action.getType() != ActionType.FORBID && action.getType() != ActionType.REQUIRE) {
            throw new IllegalArgumentException("Application conditions can be created only for REQUIRE/FORBID actions");
        }
        boolean positive = action.getType() == ActionType.REQUIRE;
        String name = DEFAULT_AC_NAME;
        String[] args = action.getArguments();
        if (args != null && args.length > 0 && args[0] != null) {
            name = args[0];
        }
        if ((ac = HenshinACUtil.getAC(rule, name, positive)) == null) {
            ac = HenshinACUtil.createAC(rule, name, positive);
        }
        return ac;
    }
}

