/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.internal.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import javax.script.ScriptEngine;
import org.eclipse.emf.henshin.model.AttributeCondition;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;

public class ConditionInfo {
    private Map<String, Collection<String>> conditionParameters = new HashMap<String, Collection<String>>();

    public ConditionInfo(Rule rule, ScriptEngine scriptEngine) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (Parameter parameter : rule.getParameters()) {
            parameterNames.add(parameter.getName());
        }
        for (AttributeCondition condition : rule.getAttributeConditions()) {
            String conditionText = condition.getConditionText();
            Collection<String> usedParameters = this.extractParameter(conditionText, parameterNames);
            this.conditionParameters.put(conditionText, usedParameters);
        }
    }

    private Collection<String> extractParameter(String testString, Collection<String> parameterNames) {
        HashSet<String> usedParameters = new HashSet<String>();
        StringTokenizer quoteParser = new StringTokenizer(testString, "\"'");
        while (quoteParser.hasMoreElements()) {
            String nonQuotedString = quoteParser.nextToken();
            StringTokenizer variableParser = new StringTokenizer(nonQuotedString, ".,()\t\r\n<>=!+[] ");
            while (variableParser.hasMoreElements()) {
                String subString = variableParser.nextToken();
                for (String parameterName : parameterNames) {
                    if (!parameterName.equals(subString)) continue;
                    usedParameters.add(parameterName);
                }
            }
            if (!quoteParser.hasMoreElements()) continue;
            quoteParser.nextElement();
        }
        return usedParameters;
    }

    public Map<String, Collection<String>> getConditionParameters() {
        return this.conditionParameters;
    }
}

