/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.matching.EmfGraph;

public class Graphs {
    public static void assertObjectInGraph(EObject obj, EmfGraph graph) throws AssertionError {
        if (!graph.geteObjects().contains(obj)) {
            throw new AssertionError((Object)("expected: Object " + obj.toString() + " contained in graph"));
        }
    }

    public static void assertObjectInGraph(EObject obj, EmfEngine engine) throws AssertionError {
        Graphs.assertObjectInGraph(obj, engine.getEmfGraph());
    }

    public static void assertObjectNotInGraph(EObject obj, EmfGraph graph) throws AssertionError {
        if (graph.geteObjects().contains(obj)) {
            throw new AssertionError((Object)("expected: Object " + obj.toString() + " not contained in graph"));
        }
    }

    public static void assertObjectNotInGraph(EObject obj, EmfEngine engine) throws AssertionError {
        Graphs.assertObjectNotInGraph(obj, engine.getEmfGraph());
    }

    public static void assertGraphsEqual(EmfGraph graph1, EmfGraph graph2, double matchSimilarityThreshold) throws AssertionError {
        MatchModel matchM;
        try {
            matchM = MatchService.doMatch((EObject)graph1.getRootObjects().toArray(new EObject[1])[0], (EObject)graph2.getRootObjects().toArray(new EObject[1])[0], null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"!!!! execution interrupted.");
        }
        for (MatchElement ma : matchM.getMatchedElements()) {
            if (ma.getSimilarity() < matchSimilarityThreshold) {
                throw new AssertionError((Object)("expected: Graphs equal, but graphs not equal. Reason: Could not match graphs. Threshold exceeded: (" + ma.getSimilarity() + "), threshold " + matchSimilarityThreshold + "."));
            }
        }
        DiffModel diffM = DiffService.doDiff((MatchModel)matchM);
        if (diffM.getDifferences().size() != 0) {
            throw new AssertionError((Object)("expected: Graphs equal, but graphs not equal (" + diffM.getDifferences().size() + " changes occured.)"));
        }
    }

    public static boolean graphsEqual(EmfGraph graph1, EmfGraph graph2, double matchSimilarityThreshold) {
        MatchModel matchM;
        System.out.println("-----------");
        try {
            matchM = MatchService.doMatch((EObject)graph1.getRootObjects().toArray(new EObject[1])[0], (EObject)graph2.getRootObjects().toArray(new EObject[1])[0], null);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted");
            return false;
        }
        for (MatchElement ma : matchM.getMatchedElements()) {
            System.out.println("-> " + ma);
            for (MatchElement sma : ma.getSubMatchElements()) {
                System.out.println("   -> " + sma);
            }
            if (!(ma.getSimilarity() < matchSimilarityThreshold)) continue;
            System.out.println("graphs not equal->similarity threshold too high");
            return false;
        }
        DiffModel diffM = DiffService.doDiff((MatchModel)matchM);
        if (diffM.getDifferences().size() == 0) {
            return true;
        }
        System.out.println("graphs not equal->differences found");
        for (DiffElement de : diffM.getDifferences()) {
            System.out.println("\t" + de);
        }
        return false;
    }
}

