/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.presentation;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.henshin.editor.menuContributors.CopySubgraphMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.CreateDynamicMC;
import org.eclipse.emf.henshin.editor.menuContributors.CreateEdgeCommandMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.CreateMappingCommandMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.CreateNestedConditionMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.FormulaCommandMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.RemoveMappedNodesMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.SimpleCommandMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.TransformationUnitCommandMenuContributor;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.presentation.HenshinActionBarContributor;
import org.eclipse.emf.henshin.presentation.HenshinEditor;
import org.eclipse.emf.henshin.presentation.HenshinEditorPlugin;
import org.eclipse.emf.henshin.provider.ReferencedRuleItemProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;

public class CustomizedHenshinActionBarContributor
extends HenshinActionBarContributor
implements CommandStackListener {
    protected Collection<IMenuManager> managedMenus = new HashSet<IMenuManager>();
    protected EditingDomain domain;
    protected List<?> currentSelection;

    @Override
    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (part != null) {
            this.domain = ((IEditingDomainProvider)part).getEditingDomain();
            this.domain.getCommandStack().addCommandStackListener((CommandStackListener)this);
        } else {
            if (this.domain != null) {
                this.domain.getCommandStack().removeCommandStackListener((CommandStackListener)this);
            }
            this.domain = null;
        }
    }

    public void commandStackChanged(EventObject event) {
        this.clearMenuManagers();
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        if (event.getSelection() instanceof IStructuredSelection) {
            this.currentSelection = ((IStructuredSelection)event.getSelection()).toList();
        }
        this.refreshMenuManagers();
    }

    protected void clearMenuManagers() {
        for (IMenuManager mm : this.managedMenus) {
            mm.removeAll();
        }
    }

    protected void refreshMenuManagers() {
        for (IMenuManager mm : this.managedMenus) {
            mm.removeAll();
            this.buildContributions(mm);
        }
    }

    @Override
    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = new MenuManager(HenshinEditorPlugin.INSTANCE.getString("_UI_CreateAdvanced_menu_item"));
        this.buildContributions((IMenuManager)submenuManager);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        this.buildNavigationActions(menuManager);
    }

    protected void buildNavigationActions(IMenuManager menuManager) {
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        menuManager.insertBefore("edit", (IContributionItem)new Separator("henshinNavigation"));
        if (selection.size() == 1) {
            if (selection.getFirstElement() instanceof ReferencedRuleItemProvider) {
                final ReferencedRuleItemProvider rrip = (ReferencedRuleItemProvider)selection.getFirstElement();
                menuManager.appendToGroup("henshinNavigation", (IAction)new Action(HenshinEditorPlugin.INSTANCE.getString("_UI_NavigationAction_GotoDeclaration")){

                    public void run() {
                        Rule rule = (Rule)rrip.getValue();
                        HenshinEditor hEditor = (HenshinEditor)CustomizedHenshinActionBarContributor.this.activeEditor;
                        hEditor.setSelectionToViewer(Collections.singleton(rule));
                    }
                });
            }
            if (selection.getFirstElement() instanceof TransformationUnit && this.domain instanceof AdapterFactoryEditingDomain) {
                TransformationUnit unit = (TransformationUnit)selection.getFirstElement();
                AdapterFactoryEditingDomain aDomain = (AdapterFactoryEditingDomain)this.domain;
                MenuManager usageMenu = new MenuManager(HenshinEditorPlugin.INSTANCE.getString("_UI_NavigationAction_GotoUsage"));
                Collection settings = EcoreUtil.UsageCrossReferencer.find((EObject)unit, (EObject)unit.eContainer());
                boolean used = false;
                for (EStructuralFeature.Setting setting : settings) {
                    used = true;
                    Adapter adapter = aDomain.getAdapterFactory().adapt((Notifier)setting.getEObject(), ITreeItemContentProvider.class);
                    if (adapter == null) continue;
                    ITreeItemContentProvider tcp = (ITreeItemContentProvider)adapter;
                    for (final Object child : tcp.getChildren((Object)setting.getEObject())) {
                        if (!(child instanceof IWrapperItemProvider) || ((IWrapperItemProvider)child).getValue() != unit) continue;
                        usageMenu.add((IAction)new Action(String.valueOf(setting.getEObject().getClass().getSimpleName()) + "." + setting.getEStructuralFeature().getName()){

                            public void run() {
                                HenshinEditor hEditor = (HenshinEditor)CustomizedHenshinActionBarContributor.this.activeEditor;
                                hEditor.setSelectionToViewer(Collections.singleton(child));
                            }
                        });
                    }
                }
                if (!used) {
                    usageMenu.add((IAction)new Action(HenshinEditorPlugin.INSTANCE.getString("_UI_NavigationAction_GotoUsage_None")){

                        public boolean isEnabled() {
                            return false;
                        }
                    });
                }
                menuManager.appendToGroup("henshinNavigation", (IContributionItem)usageMenu);
            }
        }
    }

    @Override
    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        IMenuManager subMenuManager = (IMenuManager)menuManager.find("org.eclipse.emf.henshin.modelMenuID");
        MenuManager mm = new MenuManager(HenshinEditorPlugin.INSTANCE.getString("_UI_CreateAdvanced_menu_item"));
        subMenuManager.setVisible(false);
        subMenuManager.insertBefore("additions", (IContributionItem)mm);
        this.managedMenus.add((IMenuManager)mm);
    }

    protected void buildContributions(IMenuManager menuManager) {
        CreateDynamicMC.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        SimpleCommandMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        CreateEdgeCommandMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        RemoveMappedNodesMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        CreateMappingCommandMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        FormulaCommandMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        CreateNestedConditionMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        CopySubgraphMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        TransformationUnitCommandMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        menuManager.update(true);
    }
}

