/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.eef.runtime.impl.utils.EEFUtils;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFEditorSettings;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.NavigationStep;

public class EEFEditorSettingsBuilder {
    private EObject source;
    private EStructuralFeature feature;
    private List<NavigationStep> steps;

    public static EEFEditorSettingsBuilder create(EObject source, EStructuralFeature feature) {
        return new EEFEditorSettingsBuilder(source, feature);
    }

    private EEFEditorSettingsBuilder(EObject source, EStructuralFeature feature) {
        this.source = source;
        this.feature = feature;
        this.steps = new ArrayList<NavigationStep>();
    }

    public EEFEditorSettingsBuilder nextStep(NavigationStep step) {
        this.steps.add(step);
        return this;
    }

    public EEFEditorSettings build() {
        for (NavigationStep step : this.steps) {
            if (!step.getReference().isMany() || step.getIndex() != -1) continue;
            throw new IllegalStateException("Navigation step misconfigured : Reference " + step.getReference().getName() + " is mulivalued. You must define an index.");
        }
        return new EEFEditorSettingsImpl(this.source, this.feature, Collections.unmodifiableList(this.steps));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EEFEditorSettingsImpl
    implements EEFEditorSettings {
        private EObject source;
        private EStructuralFeature feature;
        private List<NavigationStep> steps;
        private EObject significantObject;

        private EEFEditorSettingsImpl(EObject source, EStructuralFeature feature, List<NavigationStep> steps) {
            this.source = source;
            this.feature = feature;
            this.steps = steps;
        }

        @Override
        public Object getValue() {
            return this.getSignificantObject().eGet(this.feature);
        }

        public EObject getSignificantObject() {
            if (this.significantObject == null) {
                EObject current = this.source;
                for (NavigationStep step : this.steps) {
                    if (step.getReference().isMany()) {
                        List result = (List)this.source.eGet((EStructuralFeature)step.getReference());
                        List result2 = Collections.emptyList();
                        if (step.getDiscriminator() != null) {
                            for (EObject eObject : result) {
                                if (!step.getDiscriminator().isInstance((Object)eObject)) continue;
                                result2.add(eObject);
                            }
                        } else {
                            result2 = result;
                        }
                        if (step.getIndex() != -1 && step.getIndex() < result2.size()) {
                            current = (EObject)result2.get(step.getIndex());
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    current = (EObject)current.eGet((EStructuralFeature)step.getReference());
                }
                this.significantObject = current;
            }
            return this.significantObject;
        }

        public void setValue(Object newValue) {
            this.getSignificantObject().eSet(this.feature, newValue);
        }

        @Override
        public Object choiceOfValues(AdapterFactory adapterFactory) {
            return this.feature instanceof EReference ? EEFUtils.choiceOfValues(this.source, this.feature) : null;
        }

        @Override
        public boolean isAffectingFeature(EStructuralFeature feature) {
            for (NavigationStep step : this.steps) {
                if (!step.getReference().equals(feature)) continue;
                return true;
            }
            return false;
        }

        @Override
        public EObject getSource() {
            return this.source;
        }

        @Override
        public EClassifier getEType() {
            return this.feature.getEType();
        }

        @Override
        public EReference getLastReference() {
            if (this.feature instanceof EReference) {
                return (EReference)this.feature;
            }
            if (this.steps.size() > 0) {
                return this.steps.get(this.steps.size() - 1).getReference();
            }
            return null;
        }
    }
}

