/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.tests;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.emf.workspace.tests.AbstractTest;
import org.eclipse.emf.workspace.tests.fixtures.TestOperation;
import org.eclipse.emf.workspace.tests.fixtures.TestUndoContext;

public class UndoContextTest
extends AbstractTest {
    public UndoContextTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(UndoContextTest.class, "Undo Context Tests");
    }

    public void test_localChanges() {
        this.startReading();
        final Book book = (Book)this.find("root/Root Book");
        UndoContextTest.assertNotNull((Object)book);
        final Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        UndoContextTest.assertNotNull((Object)newAuthor);
        this.commit();
        TestUndoContext ctx = new TestUndoContext();
        TestOperation oper = new TestOperation(this.domain){

            protected void doExecute() {
                book.setTitle("New Title");
                newAuthor.getBooks().add((Object)book);
            }
        };
        try {
            oper.addContext(ctx);
            this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        Set affected = ResourceUndoContext.getAffectedResources((IUndoableOperation)oper);
        UndoContextTest.assertNotNull((Object)affected);
        UndoContextTest.assertEquals(Collections.singleton(this.testResource), (Object)affected);
    }

    public void test_remoteChanges() {
        ResourceImpl res2 = new ResourceImpl();
        Library lib2 = EXTLibraryFactory.eINSTANCE.createLibrary();
        res2.getContents().add((Object)lib2);
        final Writer newAuthor = EXTLibraryFactory.eINSTANCE.createWriter();
        lib2.getWriters().add((Object)newAuthor);
        this.startReading();
        this.domain.getResourceSet().getResources().add((Object)res2);
        final Book book = (Book)this.find("root/Root Book");
        UndoContextTest.assertNotNull((Object)book);
        this.commit();
        TestUndoContext ctx = new TestUndoContext();
        TestOperation oper = new TestOperation(this.domain){

            protected void doExecute() {
                book.setTitle("New Title");
                newAuthor.getBooks().add((Object)book);
            }
        };
        try {
            oper.addContext(ctx);
            this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        Set affected = ResourceUndoContext.getAffectedResources((IUndoableOperation)oper);
        UndoContextTest.assertNotNull((Object)affected);
        HashSet<Object> expected = new HashSet<Object>();
        expected.add(this.testResource);
        expected.add(res2);
        UndoContextTest.assertEquals(expected, (Object)affected);
    }
}

