/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink.elistfactory;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.teneo.eclipselink.elistfactory.EElementUtil;
import org.eclipse.emf.teneo.eclipselink.elistfactory.EListFactory;
import org.eclipse.emf.teneo.eclipselink.elistfactory.internal.messages.Messages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicEListFactoryImpl
implements EListFactory {
    @Override
    public <E> EList<E> createEList(String ePackageNsURI, String eOwnerClassName, String eStructuralFeatureName) throws ClassNotFoundException {
        EObject eOwnerObject = this.createEOwnerObject(ePackageNsURI, eOwnerClassName);
        return this.createEList(eOwnerObject, eStructuralFeatureName);
    }

    @Override
    public <E> EList<E> createEList(EObject eOwnerObject, String eStructuralFeatureName) throws ClassNotFoundException {
        EStructuralFeature eStructuralFeature = this.getEStructuralFeature(eOwnerObject, eStructuralFeatureName);
        return this.createEList(eOwnerObject, eStructuralFeature);
    }

    @Override
    public <E> EList<E> createEList(EObject eOwnerObject, EStructuralFeature eStructuralFeature) throws ClassNotFoundException {
        Assert.isNotNull((Object)eOwnerObject);
        Assert.isNotNull((Object)eStructuralFeature);
        Assert.isLegal((!eStructuralFeature.isVolatile() && EElementUtil.isListType(eStructuralFeature) ? 1 : 0) != 0, (String)Messages.assert_featureMustBeNonVolatileListItemType);
        Object result = null;
        int derivedReferenceID = EElementUtil.getDerivedStructuralFeatureID(eOwnerObject, eStructuralFeature);
        if (EElementUtil.isMapType(eStructuralFeature)) {
            result = this.createEMap(eOwnerObject, eStructuralFeature);
        } else if (EElementUtil.isFeatureMapType(eStructuralFeature)) {
            result = this.createFeatureMap(eOwnerObject, eStructuralFeature);
        } else if (this.isSuppressNotification()) {
            Class listItemClass = eStructuralFeature.getEType().getInstanceClass();
            result = this.createBasicInternalEList(listItemClass);
        } else if (EElementUtil.isContainment(eStructuralFeature) && !this.isSuppressContainment(eStructuralFeature)) {
            Class listItemClass = eStructuralFeature.getEType().getInstanceClass();
            if (EElementUtil.isBidirectional(eStructuralFeature)) {
                EReference eReference = (EReference)eStructuralFeature;
                EReference eOppositeReference = eReference.getEOpposite();
                int derivedOppositeReferenceID = EElementUtil.getDerivedStructuralFeatureID(eOwnerObject, (EStructuralFeature)eOppositeReference);
                result = EElementUtil.isResolveProxies(eStructuralFeature, this.isContainmentProxies(eStructuralFeature)) ? (eStructuralFeature.isUnsettable() ? this.createEObjectContainmentWithInverseEListUnsettableResolving(listItemClass, eOwnerObject, derivedReferenceID, derivedOppositeReferenceID) : this.createEObjectContainmentWithInverseEListResolving(listItemClass, eOwnerObject, derivedReferenceID, derivedOppositeReferenceID)) : (eStructuralFeature.isUnsettable() ? this.createEObjectContainmentWithInverseEListUnsettable(listItemClass, eOwnerObject, derivedReferenceID, derivedOppositeReferenceID) : this.createEObjectContainmentWithInverseEList(listItemClass, eOwnerObject, derivedReferenceID, derivedOppositeReferenceID));
            } else {
                result = EElementUtil.isResolveProxies(eStructuralFeature) ? (eStructuralFeature.isUnsettable() ? this.createEObjectContainmentEListUnsettableResolving(listItemClass, eOwnerObject, derivedReferenceID) : this.createEObjectContainmentEListResolving(listItemClass, eOwnerObject, derivedReferenceID)) : (eStructuralFeature.isUnsettable() ? this.createEObjectContainmentEListUnsettable(listItemClass, eOwnerObject, derivedReferenceID) : this.createEObjectContainmentEList(listItemClass, eOwnerObject, derivedReferenceID));
            }
        } else if (eStructuralFeature instanceof EReference) {
            Class listItemClass = eStructuralFeature.getEType().getInstanceClass();
            if (EElementUtil.isBidirectional(eStructuralFeature)) {
                EReference eReference = (EReference)eStructuralFeature;
                EReference eOppositeReference = eReference.getEOpposite();
                int derivedOppositeReferenceID = EElementUtil.getDerivedStructuralFeatureID(eOwnerObject, (EStructuralFeature)eOppositeReference);
                result = EElementUtil.isResolveProxies(eStructuralFeature) ? (eStructuralFeature.isUnsettable() ? (EElementUtil.isListType((EStructuralFeature)eOppositeReference) ? this.createEObjectWithInverseResolvingEListUnsettableManyInverse(listItemClass, eOwnerObject, derivedReferenceID, derivedOppositeReferenceID) : this.createEObjectWithInverseResolvingEListUnsettable(listItemClass, eOwnerObject, derivedReferenceID, derivedOppositeReferenceID)) : (EElementUtil.isListType((EStructuralFeature)eOppositeReference) ? this.createEObjectWithInverseResolvingEListManyInverse(listItemClass, eOwnerObject, derivedReferenceID, derivedOppositeReferenceID) : this.createEObjectWithInverseResolvingEList(listItemClass, eOwnerObject, derivedReferenceID, derivedOppositeReferenceID))) : (eStructuralFeature.isUnsettable() ? (EElementUtil.isListType((EStructuralFeature)eOppositeReference) ? this.createEObjectWithInverseEListUnsettableManyInverse(listItemClass, eOwnerObject, derivedReferenceID, derivedOppositeReferenceID) : this.createEObjectWithInverseEListUnsettable(listItemClass, eOwnerObject, derivedReferenceID, derivedOppositeReferenceID)) : (EElementUtil.isListType((EStructuralFeature)eOppositeReference) ? this.createEObjectWithInverseEListManyInverse(listItemClass, eOwnerObject, derivedReferenceID, derivedOppositeReferenceID) : this.createEObjectWithInverseEList(listItemClass, eOwnerObject, derivedReferenceID, derivedOppositeReferenceID)));
            } else {
                result = EElementUtil.isResolveProxies(eStructuralFeature) ? (eStructuralFeature.isUnsettable() ? this.createEObjectResolvingEListUnsettable(listItemClass, eOwnerObject, derivedReferenceID) : this.createEObjectResolvingEList(listItemClass, eOwnerObject, derivedReferenceID)) : (eStructuralFeature.isUnsettable() ? this.createEObjectEListUnsettable(listItemClass, eOwnerObject, derivedReferenceID) : this.createEObjectEList(listItemClass, eOwnerObject, derivedReferenceID));
            }
        } else if (eStructuralFeature instanceof EAttribute) {
            Class listItemClass = eStructuralFeature.getEType().getInstanceClass();
            result = eStructuralFeature.isUnique() ? (eStructuralFeature.isUnsettable() ? this.createEDataTypeUniqueEListUnsettable(listItemClass, eOwnerObject, derivedReferenceID) : this.createEDataTypeUniqueEList(listItemClass, eOwnerObject, derivedReferenceID)) : (eStructuralFeature.isUnsettable() ? this.createEDataTypeEListUnsettable(listItemClass, eOwnerObject, derivedReferenceID) : this.createEDataTypeEList(listItemClass, eOwnerObject, derivedReferenceID));
        }
        return result;
    }

    @Override
    public <K, V> EMap<K, V> createEMap(String ePackageNsURI, String eOwnerClassName, String eStructuralFeatureName) throws ClassNotFoundException {
        EObject eOwnerObject = this.createEOwnerObject(ePackageNsURI, eOwnerClassName);
        return this.createEMap(eOwnerObject, eStructuralFeatureName);
    }

    @Override
    public <K, V> EMap<K, V> createEMap(EObject eOwnerObject, String eStructuralFeatureName) throws ClassNotFoundException {
        EStructuralFeature eStructuralFeature = this.getEStructuralFeature(eOwnerObject, eStructuralFeatureName);
        return this.createEMap(eOwnerObject, eStructuralFeature);
    }

    @Override
    public <K, V> EMap<K, V> createEMap(EObject eOwnerObject, EStructuralFeature eStructuralFeature) throws ClassNotFoundException {
        Assert.isNotNull((Object)eOwnerObject);
        Assert.isNotNull((Object)eStructuralFeature);
        Assert.isLegal((!eStructuralFeature.isVolatile() && EElementUtil.isMapType(eStructuralFeature) ? 1 : 0) != 0, (String)Messages.assert_featureMustBeNonVolatileMapEntryType);
        EClass eMapEntryClass = (EClass)eStructuralFeature.getEType();
        Class mapEntryClass = eStructuralFeature.getEType().getInstanceClass();
        int derivedReferenceID = EElementUtil.getDerivedStructuralFeatureID(eOwnerObject, eStructuralFeature);
        Object result = eStructuralFeature.isUnsettable() ? this.createEcoreEMapUnsettable(eMapEntryClass, mapEntryClass, eOwnerObject, derivedReferenceID) : this.createEcoreEMap(eMapEntryClass, mapEntryClass, eOwnerObject, derivedReferenceID);
        return result;
    }

    @Override
    public FeatureMap createFeatureMap(String ePackageNsURI, String eOwnerClassName, String eStructuralFeatureName) throws ClassNotFoundException {
        EObject eOwnerObject = this.createEOwnerObject(ePackageNsURI, eOwnerClassName);
        return this.createFeatureMap(eOwnerObject, eStructuralFeatureName);
    }

    @Override
    public FeatureMap createFeatureMap(EObject eOwnerObject, String eStructuralFeatureName) throws ClassNotFoundException {
        EStructuralFeature eStructuralFeature = this.getEStructuralFeature(eOwnerObject, eStructuralFeatureName);
        return this.createFeatureMap(eOwnerObject, eStructuralFeature);
    }

    @Override
    public FeatureMap createFeatureMap(EObject eOwnerObject, EStructuralFeature eStructuralFeature) throws ClassNotFoundException {
        Assert.isNotNull((Object)eOwnerObject);
        Assert.isNotNull((Object)eStructuralFeature);
        Assert.isLegal((!eStructuralFeature.isVolatile() && EElementUtil.isFeatureMapType(eStructuralFeature) ? 1 : 0) != 0, (String)Messages.assert_featureMustBeNonVolatileFeatureMapEntryType);
        int derivedReferenceID = EElementUtil.getDerivedStructuralFeatureID(eOwnerObject, eStructuralFeature);
        BasicFeatureMap featureMap = this.createBasicFeatureMap(eOwnerObject, derivedReferenceID);
        return this.createWrappedFeatureMap((FeatureMap)featureMap);
    }

    protected boolean isContainmentProxies(EStructuralFeature eStructuralFeature) {
        return false;
    }

    protected boolean isSuppressContainment(EStructuralFeature eStructuralFeature) {
        return false;
    }

    protected boolean isSuppressNotification() {
        return false;
    }

    protected FeatureMap createWrappedFeatureMap(FeatureMap featureMap) {
        return featureMap;
    }

    protected <E> BasicInternalEList<E> createBasicInternalEList(Class<? extends E> listItemClass) {
        return new BasicInternalEList(listItemClass);
    }

    protected <E> EObjectEList<E> createEObjectEList(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID) {
        return new EObjectEList(listItemClass, (InternalEObject)eOwnerObject, eReferenceID);
    }

    protected <E> EObjectEList.Unsettable<E> createEObjectEListUnsettable(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID) {
        return new EObjectEList.Unsettable(listItemClass, (InternalEObject)eOwnerObject, eReferenceID);
    }

    protected <E> EObjectResolvingEList<E> createEObjectResolvingEList(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID) {
        return new EObjectResolvingEList(listItemClass, (InternalEObject)eOwnerObject, eReferenceID);
    }

    protected <E> EObjectResolvingEList.Unsettable<E> createEObjectResolvingEListUnsettable(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID) {
        return new EObjectResolvingEList.Unsettable(listItemClass, (InternalEObject)eOwnerObject, eReferenceID);
    }

    protected <E> EObjectWithInverseEList<E> createEObjectWithInverseEList(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID, int eOppositeReferenceID) {
        return new EObjectWithInverseEList(listItemClass, (InternalEObject)eOwnerObject, eReferenceID, eOppositeReferenceID);
    }

    protected <E> EObjectWithInverseEList.Unsettable<E> createEObjectWithInverseEListUnsettable(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID, int eOppositeReferenceID) {
        return new EObjectWithInverseEList.Unsettable(listItemClass, (InternalEObject)eOwnerObject, eReferenceID, eOppositeReferenceID);
    }

    protected <E> EObjectWithInverseEList.ManyInverse<E> createEObjectWithInverseEListManyInverse(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID, int eOppositeReferenceID) {
        return new EObjectWithInverseEList.ManyInverse(listItemClass, (InternalEObject)eOwnerObject, eReferenceID, eOppositeReferenceID);
    }

    protected <E> EObjectWithInverseEList.Unsettable.ManyInverse<E> createEObjectWithInverseEListUnsettableManyInverse(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID, int eOppositeReferenceID) {
        return new EObjectWithInverseEList.Unsettable.ManyInverse(listItemClass, (InternalEObject)eOwnerObject, eReferenceID, eOppositeReferenceID);
    }

    protected <E> EObjectWithInverseResolvingEList<E> createEObjectWithInverseResolvingEList(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID, int eOppositeReferenceID) {
        return new EObjectWithInverseResolvingEList(listItemClass, (InternalEObject)eOwnerObject, eReferenceID, eOppositeReferenceID);
    }

    protected <E> EObjectWithInverseResolvingEList.Unsettable<E> createEObjectWithInverseResolvingEListUnsettable(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID, int eOppositeReferenceID) {
        return new EObjectWithInverseResolvingEList.Unsettable(listItemClass, (InternalEObject)eOwnerObject, eReferenceID, eOppositeReferenceID);
    }

    protected <E> EObjectWithInverseResolvingEList.ManyInverse<E> createEObjectWithInverseResolvingEListManyInverse(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID, int eOppositeReferenceID) {
        return new EObjectWithInverseResolvingEList.ManyInverse(listItemClass, (InternalEObject)eOwnerObject, eReferenceID, eOppositeReferenceID);
    }

    protected <E> EObjectWithInverseResolvingEList.Unsettable.ManyInverse<E> createEObjectWithInverseResolvingEListUnsettableManyInverse(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID, int eOppositeReferenceID) {
        return new EObjectWithInverseResolvingEList.Unsettable.ManyInverse(listItemClass, (InternalEObject)eOwnerObject, eReferenceID, eOppositeReferenceID);
    }

    protected <E> EObjectContainmentEList<E> createEObjectContainmentEList(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID) {
        return new EObjectContainmentEList(listItemClass, (InternalEObject)eOwnerObject, eReferenceID);
    }

    protected <E> EObjectContainmentEList.Unsettable<E> createEObjectContainmentEListUnsettable(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID) {
        return new EObjectContainmentEList.Unsettable(listItemClass, (InternalEObject)eOwnerObject, eReferenceID);
    }

    protected <E> EObjectContainmentEList.Resolving<E> createEObjectContainmentEListResolving(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID) {
        return new EObjectContainmentEList.Resolving(listItemClass, (InternalEObject)eOwnerObject, eReferenceID);
    }

    protected <E> EObjectContainmentEList.Unsettable.Resolving<E> createEObjectContainmentEListUnsettableResolving(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID) {
        return new EObjectContainmentEList.Unsettable.Resolving(listItemClass, (InternalEObject)eOwnerObject, eReferenceID);
    }

    protected <E> EObjectContainmentWithInverseEList<E> createEObjectContainmentWithInverseEList(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID, int eOppositeReferenceID) {
        return new EObjectContainmentWithInverseEList(listItemClass, (InternalEObject)eOwnerObject, eReferenceID, eOppositeReferenceID);
    }

    protected <E> EObjectContainmentWithInverseEList.Unsettable<E> createEObjectContainmentWithInverseEListUnsettable(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID, int eOppositeReferenceID) {
        return new EObjectContainmentWithInverseEList.Unsettable(listItemClass, (InternalEObject)eOwnerObject, eReferenceID, eOppositeReferenceID);
    }

    protected <E> EObjectContainmentWithInverseEList.Resolving<E> createEObjectContainmentWithInverseEListResolving(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID, int eOppositeReferenceID) {
        return new EObjectContainmentWithInverseEList.Resolving(listItemClass, (InternalEObject)eOwnerObject, eReferenceID, eOppositeReferenceID);
    }

    protected <E> EObjectContainmentWithInverseEList.Unsettable.Resolving<E> createEObjectContainmentWithInverseEListUnsettableResolving(Class<?> listItemClass, EObject eOwnerObject, int eReferenceID, int eOppositeReferenceID) {
        return new EObjectContainmentWithInverseEList.Unsettable.Resolving(listItemClass, (InternalEObject)eOwnerObject, eReferenceID, eOppositeReferenceID);
    }

    protected <E> EDataTypeEList<E> createEDataTypeEList(Class<?> listItemClass, EObject eOwnerObject, int eAttributeID) {
        return new EDataTypeEList(listItemClass, (InternalEObject)eOwnerObject, eAttributeID);
    }

    protected <E> EDataTypeEList.Unsettable<E> createEDataTypeEListUnsettable(Class<?> listItemClass, EObject eOwnerObject, int eAttributeID) {
        return new EDataTypeEList.Unsettable(listItemClass, (InternalEObject)eOwnerObject, eAttributeID);
    }

    protected <E> EDataTypeUniqueEList<E> createEDataTypeUniqueEList(Class<?> listItemClass, EObject eOwnerObject, int eAttributeID) {
        return new EDataTypeUniqueEList(listItemClass, (InternalEObject)eOwnerObject, eAttributeID);
    }

    protected <E> EDataTypeUniqueEList.Unsettable<E> createEDataTypeUniqueEListUnsettable(Class<?> listItemClass, EObject eOwnerObject, int eAttributeID) {
        return new EDataTypeUniqueEList.Unsettable(listItemClass, (InternalEObject)eOwnerObject, eAttributeID);
    }

    protected <K, V> EcoreEMap<K, V> createEcoreEMap(EClass eMapEntryClass, Class<?> mapEntryClass, EObject eOwnerObject, int eReferenceID) {
        return new EcoreEMap(eMapEntryClass, mapEntryClass, (InternalEObject)eOwnerObject, eReferenceID);
    }

    protected <K, V> EcoreEMap.Unsettable<K, V> createEcoreEMapUnsettable(EClass eMapEntryClass, Class<?> mapEntryClass, EObject eOwnerObject, int eReferenceID) {
        return new EcoreEMap.Unsettable(eMapEntryClass, mapEntryClass, (InternalEObject)eOwnerObject, eReferenceID);
    }

    protected BasicFeatureMap createBasicFeatureMap(EObject eOwnerObject, int eReferenceID) {
        return new BasicFeatureMap((InternalEObject)eOwnerObject, eReferenceID);
    }

    private EObject createEOwnerObject(String ePackageNsURI, String eOwnerClassName) {
        EPackage ePackage = EElementUtil.findEPackage(ePackageNsURI);
        EClass eOwnerClass = EElementUtil.findEClass(ePackage, eOwnerClassName);
        EFactory eFactory = ePackage.getEFactoryInstance();
        return eFactory.create(eOwnerClass);
    }

    private EStructuralFeature getEStructuralFeature(EObject eOwnerObject, String eStructuralFeatureName) {
        Assert.isNotNull((Object)eOwnerObject);
        Assert.isLegal((eStructuralFeatureName != null && eStructuralFeatureName.trim().length() > 0 ? 1 : 0) != 0);
        EStructuralFeature eStructuralFeature = eOwnerObject.eClass().getEStructuralFeature(eStructuralFeatureName);
        Assert.isTrue((eStructuralFeature != null ? 1 : 0) != 0, (String)NLS.bind((String)Messages.assert_couldNotFindFeature$0InEClass$1, (Object)eStructuralFeatureName, (Object)eOwnerObject.eClass().getName()));
        return eStructuralFeature;
    }
}

