/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.TeneoException;
import org.eclipse.emf.teneo.annotations.mapper.PersistenceMappingBuilder;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerFactory;
import org.eclipse.emf.teneo.extension.ExtensionUtil;
import org.eclipse.emf.teneo.jpox.mapper.JPOXMappingGenerator;

public class GenerateJDO {
    private static Log log = LogFactory.getLog(GenerateJDO.class);

    public static void main(String[] args) {
        Properties options = new Properties();
        ArrayList<String> ecores = new ArrayList<String>();
        String targetFileName = null;
        int i = 0;
        while (i < args.length) {
            if (i == 0) {
                targetFileName = args[0];
            } else if (args[i].startsWith("+")) {
                String[] keyValue = args[i].substring(1).split(",");
                options.put(keyValue[0], keyValue[1]);
            } else if (args[i].startsWith("-")) {
                String[] epacks;
                String[] stringArray = epacks = args[i].substring(1).split(",");
                int n = epacks.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    try {
                        log.debug((Object)("Loading class " + element + " should be an epackage"));
                        Class<?> epack = Class.forName(element);
                        if (!EPackage.class.isAssignableFrom(epack)) {
                            log.warn((Object)("JDO generator found " + epack.getName() + " but this is not an EPackage, ignoring it"));
                        }
                    }
                    catch (Throwable t) {
                        log.error((Object)("Exception while instantiating " + element), t);
                    }
                    ++n2;
                }
            } else {
                ecores.add(args[i]);
            }
            ++i;
        }
        GenerateJDO.createORMapperFile(targetFileName, ecores.toArray(new String[ecores.size()]), options);
    }

    private static void createORMapperFile(String targetFileName, String[] ecores, Properties options) {
        GenerateJDO.createORMapperFile(targetFileName, ecores, options, ExtensionManagerFactory.getInstance().create());
    }

    private static void createORMapperFile(String targetFileName, String[] ecores, Properties options, ExtensionManager extensionManager) {
        extensionManager.registerExtension(ExtensionUtil.createExtension(JPOXMappingGenerator.class, JPOXMappingGenerator.class));
        extensionManager.registerExtension(ExtensionUtil.createExtension(JPOXMappingGenerator.class, JPOXMappingGenerator.class));
        try {
            File firstEcore = new File(ecores[0]);
            File file = new File(firstEcore.getParentFile(), targetFileName);
            File archiveFile = new File(firstEcore.getParentFile(), String.valueOf(targetFileName) + "_old");
            if (file.exists()) {
                if (archiveFile.exists()) {
                    archiveFile.delete();
                }
                GenerateJDO.copyFile(file, archiveFile);
                file.delete();
            }
            file.createNewFile();
            PersistenceOptions po = (PersistenceOptions)extensionManager.getExtension(PersistenceOptions.class, new Object[]{options});
            PersistenceMappingBuilder pmb = (PersistenceMappingBuilder)extensionManager.getExtension(PersistenceMappingBuilder.class);
            PAnnotatedModel paModel = pmb.buildMapping(ecores, po, extensionManager);
            JPOXMappingGenerator jmg = (JPOXMappingGenerator)extensionManager.getExtension(JPOXMappingGenerator.class);
            jmg.setPersistenceOptions(new PersistenceOptions());
            FileWriter writer = new FileWriter(file);
            writer.write(jmg.generate(paModel));
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)e);
            throw new TeneoException("IOException when creating or mapping file", (Throwable)e);
        }
    }

    public static void copyFile(File src, File dst) throws IOException {
        int len;
        if (!dst.exists()) {
            dst.createNewFile();
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

