/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.nodes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum NodeEnum implements Enumerator
{
    A(0, "A", "A"),
    B(1, "B", "B"),
    C(2, "C", "C");

    public static final String copyright = "Copyright (c) 2011, 2012 Obeo.\r\nAll rights reserved. This program and the accompanying materials\r\nare made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at\r\nhttp://www.eclipse.org/legal/epl-v10.html\r\n\r\nContributors:\r\n    Obeo - initial API and implementation";
    public static final int A_VALUE = 0;
    public static final int B_VALUE = 1;
    public static final int C_VALUE = 2;
    private static final NodeEnum[] VALUES_ARRAY;
    public static final List<NodeEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new NodeEnum[]{A, B, C};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static NodeEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NodeEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NodeEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NodeEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NodeEnum get(int value) {
        switch (value) {
            case 0: {
                return A;
            }
            case 1: {
                return B;
            }
            case 2: {
                return C;
            }
        }
        return null;
    }

    private NodeEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

