/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant.CompositeTransformationModel;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant.CreateQvtoAntTaskWizard;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant.TaskModel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class CompositeTransformationContentPage
extends WizardPage {
    private final CompositeTransformationModel myModel;
    private boolean myWasEverShown;
    private Text myProjectNameText;
    private Text myTargetNameText;
    private TreeViewer myTreeViewer;
    private Button myUp;
    private Button myDown;
    private Button myDelete;

    public CompositeTransformationContentPage(CompositeTransformationModel model) {
        super("transformationPage");
        this.myModel = model;
        this.setTitle(Messages.TransformPage_title);
        this.setDescription(Messages.TransformPage_descr);
    }

    public boolean isPageComplete() {
        return this.myWasEverShown && super.isPageComplete();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(Messages.TransformPage_project);
        this.myProjectNameText = new Text(container, 2052);
        this.myProjectNameText.setLayoutData((Object)new GridData(768));
        this.myProjectNameText.setText(this.myModel.getProjectName());
        this.myProjectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompositeTransformationContentPage.this.myModel.setProjectName(CompositeTransformationContentPage.this.myProjectNameText.getText());
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.TransformPage_task);
        this.myTargetNameText = new Text(container, 2052);
        this.myTargetNameText.setLayoutData((Object)new GridData(768));
        this.myTargetNameText.setText(this.myModel.getTargetName());
        this.myTargetNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompositeTransformationContentPage.this.myModel.setTargetName(CompositeTransformationContentPage.this.myTargetNameText.getText());
            }
        });
        Composite composite = new Composite(container, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.marginWidth = 0;
        layout.marginRight = 0;
        composite.setLayout((Layout)layout);
        int style = 101124;
        this.myTreeViewer = new TreeViewer(composite, style);
        this.myTreeViewer.getControl().setLayoutData((Object)new GridData(1808));
        DataProvider dp = new DataProvider();
        this.myTreeViewer.setContentProvider((IContentProvider)dp);
        this.myTreeViewer.setLabelProvider((IBaseLabelProvider)dp);
        this.myTreeViewer.setInput((Object)this.myModel);
        this.myTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CompositeTransformationContentPage.this.updateButtons(event.getSelection());
            }
        });
        Tree tree = this.myTreeViewer.getTree();
        TableLayout tableLayout = new TableLayout();
        TreeColumn col = new TreeColumn(tree, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, true));
        col.setText(Messages.Name);
        col = new TreeColumn(tree, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, true));
        col.setText(Messages.Value);
        tree.setLayout((Layout)tableLayout);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(1040));
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        layout.marginTop = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginRight = 0;
        buttons.setLayout((Layout)layout);
        CompositeTransformationContentPage.newButton(buttons, Messages.Add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateQvtoAntTaskWizard taskWizard = new CreateQvtoAntTaskWizard();
                WizardDialog dialog = new WizardDialog(CompositeTransformationContentPage.this.getContainer().getShell(), (IWizard)taskWizard);
                dialog.create();
                if (dialog.open() == 0) {
                    CompositeTransformationContentPage.this.myModel.getTaskModels().add(taskWizard.getResult());
                    CompositeTransformationContentPage.this.myTreeViewer.refresh();
                }
            }
        });
        this.myDelete = CompositeTransformationContentPage.newButton(buttons, Messages.Delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedElement = CompositeTransformationContentPage.this.getSelectedElement();
                if (selectedElement instanceof TaskModel) {
                    CompositeTransformationContentPage.this.myModel.getTaskModels().remove(selectedElement);
                    CompositeTransformationContentPage.this.myTreeViewer.refresh();
                }
            }
        });
        this.myUp = CompositeTransformationContentPage.newButton(buttons, Messages.Up, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i;
                Object selectedElement = CompositeTransformationContentPage.this.getSelectedElement();
                if (selectedElement instanceof TaskModel && (i = CompositeTransformationContentPage.this.myModel.getTaskModels().indexOf(selectedElement)) > 0) {
                    TaskModel p = CompositeTransformationContentPage.this.myModel.getTaskModels().get(i - 1);
                    CompositeTransformationContentPage.this.myModel.getTaskModels().set(i - 1, (TaskModel)selectedElement);
                    CompositeTransformationContentPage.this.myModel.getTaskModels().set(i, p);
                    CompositeTransformationContentPage.this.myTreeViewer.refresh();
                }
            }
        });
        this.myDown = CompositeTransformationContentPage.newButton(buttons, Messages.Down, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i;
                Object selectedElement = CompositeTransformationContentPage.this.getSelectedElement();
                if (selectedElement instanceof TaskModel && (i = CompositeTransformationContentPage.this.myModel.getTaskModels().indexOf(selectedElement)) < CompositeTransformationContentPage.this.myModel.getTaskModels().size() - 1) {
                    TaskModel n = CompositeTransformationContentPage.this.myModel.getTaskModels().get(i + 1);
                    CompositeTransformationContentPage.this.myModel.getTaskModels().set(i + 1, (TaskModel)selectedElement);
                    CompositeTransformationContentPage.this.myModel.getTaskModels().set(i, n);
                    CompositeTransformationContentPage.this.myTreeViewer.refresh();
                }
            }
        });
        this.setControl((Control)container);
        this.updateButtons((ISelection)StructuredSelection.EMPTY);
    }

    private Object getSelectedElement() {
        IStructuredSelection sel = (IStructuredSelection)this.myTreeViewer.getSelection();
        return sel.getFirstElement();
    }

    protected void updateButtons(ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        Object firstElement = sel.getFirstElement();
        boolean up = false;
        boolean down = false;
        boolean del = false;
        if (firstElement instanceof TaskModel) {
            int i = this.myModel.getTaskModels().indexOf(firstElement);
            up = i > 0;
            down = i < this.myModel.getTaskModels().size() - 1;
            del = true;
        }
        this.myDelete.setEnabled(!selection.isEmpty() && del);
        this.myUp.setEnabled(!selection.isEmpty() && up);
        this.myDown.setEnabled(!selection.isEmpty() && down);
    }

    private static Button newButton(Composite buttons, String caption, SelectionListener listener) {
        Button button = new Button(buttons, 8);
        button.setText(caption);
        GridData gridData = new GridData(768);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(listener);
        return button;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.myWasEverShown = true;
        }
        super.setVisible(visible);
    }

    private static class DataProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITreeContentProvider {
        private final Map<Object, Object> myParentCache = new HashMap<Object, Object>();

        private DataProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TaskModel) {
                TaskModel value = (TaskModel)element;
                return columnIndex == 0 ? value.getTaskName() : " < " + value.getName() + " >";
            }
            if (element instanceof Map.Entry) {
                Map.Entry value = (Map.Entry)element;
                return columnIndex == 0 ? (String)value.getKey() : String.valueOf(value.getValue());
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TaskModel) {
                TaskModel model = (TaskModel)parentElement;
                Set<Map.Entry<String, Object>> entrySet = model.getAttributes().entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    this.myParentCache.put(entry, parentElement);
                }
                return entrySet.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return this.myParentCache.get(element);
        }

        public boolean hasChildren(Object element) {
            return element instanceof TaskModel;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CompositeTransformationModel) {
                CompositeTransformationModel model = (CompositeTransformationModel)inputElement;
                return model.getTaskModels().toArray();
            }
            return null;
        }

        public void dispose() {
            this.myParentCache.clear();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

