/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.OperationMatcher;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.DiagnosticUtil;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxMessages;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaMethodHandlerFactory;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaModuleLoader;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.ModuleHandle;
import org.eclipse.m2m.internal.qvt.oml.common.util.LineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.common.util.StringLineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.cst.CSTFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.types.OCLStandardLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaBlackboxProvider
extends BlackboxProvider {
    public static final String CLASS_NAME_SEPARATOR = ".";

    static BlackboxProvider.InstanceAdapterFactory createInstanceAdapterFactory(final Class<?> javaModuleClass) {
        return new BlackboxProvider.InstanceAdapterFactory(){

            public Object createAdapter(EObject moduleInstance) {
                try {
                    return javaModuleClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Illegal adapter instance", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Illegal adapter instance", e);
                }
            }
        };
    }

    private JavaModuleLoader createJavaModuleLoader() {
        return new JavaModuleLoader(){
            JavaMethodHandlerFactory handlerFactory;

            @Override
            protected void loadModule(QvtOperationalModuleEnv moduleEnv, Class<?> javaModuleClass) {
                this.handlerFactory = new JavaMethodHandlerFactory((OCLStandardLibrary<EClassifier>)moduleEnv.getOCLStandardLibrary());
                Module module = moduleEnv.getModuleContextType();
                ASTBindingHelper.createCST2ASTBinding((CSTNode)CSTFactory.eINSTANCE.createLibraryCS(), module, moduleEnv);
                JavaBlackboxProvider.setInstanceAdapterFactory(module, JavaBlackboxProvider.createInstanceAdapterFactory(javaModuleClass));
            }

            @Override
            protected void loadOperation(EOperation operation, Method javaOperation) {
                JavaBlackboxProvider.this.setOperationHandler(operation, this.handlerFactory.createHandler(javaOperation), true);
            }
        };
    }

    protected static String getPackageNameFromJavaClass(String className) {
        int lastSeparatorPos = className.lastIndexOf(CLASS_NAME_SEPARATOR);
        if (lastSeparatorPos < 0) {
            return null;
        }
        return className.substring(0, lastSeparatorPos);
    }

    protected static String getSimpleNameFromJavaClass(String className) {
        int lastSeparatorPos = className.lastIndexOf(CLASS_NAME_SEPARATOR);
        if (lastSeparatorPos < 0) {
            return className;
        }
        return className.substring(lastSeparatorPos + 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class JavaUnitDescriptor
    extends BlackboxUnitDescriptor {
        private BlackboxUnit unit;
        private Map<ModuleHandle, Map<String, List<EOperation>>> fModules;

        public JavaUnitDescriptor(String unitQualifiedName) {
            super(JavaBlackboxProvider.this, unitQualifiedName);
            this.fModules = new LinkedHashMap<ModuleHandle, Map<String, List<EOperation>>>();
        }

        protected void addModuleHandle(ModuleHandle moduleHandle) {
            this.fModules.put(moduleHandle, new LinkedHashMap());
        }

        @Override
        public Collection<CallHandler> getBlackboxCallHandler(ImperativeOperation imperativeOp, QvtOperationalModuleEnv env) {
            Set<String> importedLibs = env.getImportedNativeLibs().get(this.getURI());
            List<CallHandler> result = Collections.emptyList();
            for (Map.Entry<ModuleHandle, Map<String, List<EOperation>>> nextEntry : this.fModules.entrySet()) {
                List<EOperation> listOp;
                if (!env.getImportedNativeLibs().isEmpty() && !importedLibs.contains(nextEntry.getKey().getModuleName()) || (listOp = nextEntry.getValue().get(imperativeOp.getName())) == null) continue;
                for (EOperation libraryOp : listOp) {
                    if (!OperationMatcher.matchOperation((QvtOperationalEnv)env, imperativeOp, libraryOp)) continue;
                    if (result.isEmpty()) {
                        result = new LinkedList<CallHandler>();
                    }
                    result.add(CallHandlerAdapter.getDispatcher(libraryOp));
                }
            }
            return result;
        }

        @Override
        public Collection<CallHandler> getBlackboxCallHandler(OperationalTransformation transformation, QvtOperationalModuleEnv env) {
            Set<String> importedLibs = env.getImportedNativeLibs().get(this.getURI());
            List<CallHandler> result = Collections.emptyList();
            for (Map.Entry<ModuleHandle, Map<String, List<EOperation>>> nextEntry : this.fModules.entrySet()) {
                List<EOperation> listOp;
                if (!env.getImportedNativeLibs().isEmpty() && !importedLibs.contains(nextEntry.getKey().getModuleName()) || (listOp = nextEntry.getValue().get(transformation.getName())) == null) continue;
                for (EOperation libraryOp : listOp) {
                    if (!OperationMatcher.matchOperation((QvtOperationalEnv)env, transformation, libraryOp)) continue;
                    if (result.isEmpty()) {
                        result = new LinkedList<CallHandler>();
                    }
                    result.add(CallHandlerAdapter.getDispatcher(libraryOp));
                }
            }
            return result;
        }

        @Override
        public BlackboxUnit load(LoadContext context) throws BlackboxException {
            if (this.unit != null) {
                return this.unit;
            }
            JavaModuleLoader javaModuleLoader = JavaBlackboxProvider.this.createJavaModuleLoader();
            Resource unitResource = new EcoreResourceFactoryImpl().createResource(this.getURI());
            BasicDiagnostic errors = null;
            LinkedList<QvtOperationalModuleEnv> loadedModules = new LinkedList<QvtOperationalModuleEnv>();
            for (Map.Entry<ModuleHandle, Map<String, List<EOperation>>> nextEntry : this.fModules.entrySet()) {
                Diagnostic diagnostic = javaModuleLoader.loadModule(nextEntry.getKey(), nextEntry.getValue(), context);
                if (EmfUtilPlugin.isSuccess((Diagnostic)diagnostic)) {
                    QvtOperationalModuleEnv nextModuleEnv = javaModuleLoader.getLoadedModule();
                    nextModuleEnv.getTypeResolver().getResource().setURI(this.getURI());
                    ASTBindingHelper.createModuleSourceBinding((EObject)nextModuleEnv.getModuleContextType(), this.getURI(), (LineNumberProvider)new StringLineNumberProvider(""));
                    loadedModules.add(nextModuleEnv);
                    unitResource.getContents().add((Object)nextModuleEnv.getModuleContextType());
                    if (diagnostic.getSeverity() == 0) continue;
                    QvtPlugin.logDiagnostic(diagnostic);
                    continue;
                }
                if (errors == null) {
                    String message = NLS.bind(JavaBlackboxMessages.BlackboxUnitLoadFailed, this.getQualifiedName());
                    errors = DiagnosticUtil.createErrorDiagnostic(message);
                }
                errors.add(diagnostic);
            }
            if (errors != null) {
                BasicDiagnostic failDiagnostic = errors;
                this.unit = new BlackboxUnit((Diagnostic)failDiagnostic){
                    private final /* synthetic */ Diagnostic val$failDiagnostic;
                    {
                        this.val$failDiagnostic = diagnostic;
                    }

                    @Override
                    public List<QvtOperationalModuleEnv> getElements() {
                        return Collections.emptyList();
                    }

                    @Override
                    public Diagnostic getDiagnostic() {
                        return this.val$failDiagnostic;
                    }
                };
                assert (errors.getSeverity() == 4);
                throw new BlackboxException((Diagnostic)errors);
            }
            this.unit = JavaBlackboxProvider.this.createBlackboxUnit(loadedModules);
            return this.unit;
        }

        protected void unload() {
            for (Map<String, List<EOperation>> operations : this.fModules.values()) {
                operations.clear();
            }
            this.unit = null;
        }
    }
}

