/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.Partitioner;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;

class RealizedPartition
extends AbstractPartition {
    public RealizedPartition(@NonNull Partitioner partitioner) {
        super(partitioner);
        Iterable<@NonNull Node> predicatedMiddleNodes = partitioner.getPredicatedMiddleNodes();
        Iterable<@NonNull Node> realizedMiddleNodes = partitioner.getRealizedMiddleNodes();
        Iterable<@NonNull Node> realizedOutputNodes = partitioner.getRealizedOutputNodes();
        assert (Iterables.isEmpty(predicatedMiddleNodes));
        this.addLoadedNavigationEdgeSourceAndTargetNodes();
        for (Node node : Iterables.concat(realizedMiddleNodes, realizedOutputNodes)) {
            this.gatherSourceNavigations(node, RegionUtil.getNodeRole((Node)node));
            for (NavigableEdge navigationEdge : node.getNavigationEdges()) {
                Node targetNode;
                if (!navigationEdge.isRealized() || (targetNode = navigationEdge.getEdgeTarget()).isPredicated() || targetNode.isRealized()) continue;
                this.gatherSourceNavigations(targetNode, RegionUtil.getNodeRole((Node)targetNode));
            }
        }
        this.resolveComputations();
        this.resolvePredicates();
        this.resolveEdgeRoles();
    }

    protected void addLoadedNavigationEdgeSourceAndTargetNodes() {
        for (NavigableEdge edge : this.partitioner.getRegion().getNavigationEdges()) {
            if (!edge.isLoaded()) continue;
            Node sourceNode = edge.getEdgeSource();
            Node targetNode = edge.getEdgeTarget();
            if (!this.hasNode(sourceNode)) {
                this.addNode(sourceNode, RegionUtil.getNodeRole((Node)sourceNode));
            }
            if (this.hasNode(targetNode)) continue;
            this.addNode(targetNode, RegionUtil.getNodeRole((Node)targetNode));
        }
    }

    private void gatherSourceNavigations(@NonNull Node targetNode, @NonNull Role targetNodeRole) {
        if (!this.hasNode(targetNode)) {
            this.addNode(targetNode, targetNodeRole);
            for (Node sourceNode : this.getPredecessors(targetNode)) {
                this.gatherSourceNavigations(sourceNode, RegionUtil.getNodeRole((Node)sourceNode));
            }
        }
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Role edgeRole = RegionUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED) assert (!this.partitioner.hasRealizedEdge(edge));
        return edgeRole;
    }
}

