/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.text.AtlHeuristicScanner;
import org.eclipse.m2m.atl.adt.ui.text.AtlIndenter;
import org.eclipse.m2m.atl.adt.ui.text.AtlPairMatcher;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.common.IAtlLexems;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class AtlAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private boolean fCloseBrace;
    private boolean fIsSmartMode;
    private String fPartitioning;

    public AtlAutoIndentStrategy(String partitioning) {
        this.fPartitioning = partitioning;
    }

    private static int computeAnonymousPosition(IDocument document, int offset, String partitioning, int max) {
        int openingParen;
        int startScan;
        AtlHeuristicScanner scanner = new AtlHeuristicScanner(document);
        int pos = offset;
        int length = max;
        int scanTo = scanner.scanForward(pos, length, '}');
        if (scanTo == -1) {
            scanTo = length;
        }
        int closingParen = AtlAutoIndentStrategy.findClosingParenToLeft(scanner, pos) - 1;
        while ((closingParen = scanner.scanForward(startScan = closingParen + 1, scanTo, ')')) != -1 && (openingParen = scanner.findOpeningPeer(closingParen - 1, '(', ')')) >= 1) {
            if (openingParen <= pos) continue;
        }
        return -1;
    }

    private static int findClosingParenToLeft(AtlHeuristicScanner scanner, int position) {
        if (position < 1) {
            return position;
        }
        if (scanner.previousToken(position - 1, -2) == 6) {
            return scanner.getPosition() + 1;
        }
        return position;
    }

    private static String getLineDelimiter(IDocument document) {
        try {
            if (document.getNumberOfLines() > 1) {
                return document.getLineDelimiter(0);
            }
        }
        catch (BadLocationException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return System.getProperty("line.separator");
    }

    private void clearCachedValues() {
        this.fCloseBrace = AtlUIPlugin.getDefault().getPreferenceStore().getBoolean("Atl.Typing.CloseBraces");
        this.fIsSmartMode = this.computeSmartMode();
    }

    private boolean closeBrace() {
        return this.fCloseBrace;
    }

    private boolean computeSmartMode() {
        IEditorPart part;
        IWorkbenchPage page = AtlUIPlugin.getActivePage();
        return page != null && (part = page.getActiveEditor()) instanceof ITextEditorExtension3;
    }

    protected String createIndent() {
        return "\t";
    }

    protected String createIndent(int indents) {
        String res = "";
        String indent = this.createIndent();
        int i = 0;
        while (i < indents) {
            res = res.concat(indent);
            ++i;
        }
        return res;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!command.doit) {
            return;
        }
        this.clearCachedValues();
        if (!this.isSmartMode()) {
            super.customizeDocumentCommand(document, command);
            return;
        }
        if (command.length <= 0 && command.text != null && this.isLineDelimiter(document, command.text)) {
            this.smartIndentAfterNewLine(document, command);
        } else if (command.text.length() == 1) {
            this.smartIndentAfterBlockDelimiter(document, command);
        } else {
            super.customizeDocumentCommand(document, command);
        }
    }

    private int findMatchingOpenBracket(IDocument document, int cursorAt, char closingPeer) {
        AtlPairMatcher bracketsMatcher = new AtlPairMatcher(IAtlLexems.BRACKETS);
        char openingPeer = bracketsMatcher.getMatchingPair(closingPeer);
        try {
            return document.getLineOfOffset(bracketsMatcher.searchForOpeningPeer(cursorAt, openingPeer, closingPeer, document));
        }
        catch (BadLocationException e) {
            return 0;
        }
        catch (IOException e) {
            return 0;
        }
    }

    private int getBracketCount(IDocument d, int startOffset, int endOffset, boolean ignoreCloseBrackets) throws BadLocationException {
        int bracketCount = 0;
        block6: while (startOffset < endOffset) {
            char curr = d.getChar(startOffset);
            ++startOffset;
            switch (curr) {
                case '-': {
                    char next;
                    if (startOffset >= endOffset || (next = d.getChar(startOffset)) != '-') continue block6;
                    startOffset = endOffset;
                    break;
                }
                case '{': {
                    ++bracketCount;
                    ignoreCloseBrackets = false;
                    break;
                }
                case '}': {
                    if (ignoreCloseBrackets) break;
                    --bracketCount;
                    break;
                }
                case '\"': 
                case '\'': {
                    startOffset = this.getStringEnd(d, startOffset, endOffset, curr);
                }
            }
        }
        return bracketCount;
    }

    protected String getIndentOfLine(IDocument document, int line) throws BadLocationException {
        if (line > -1) {
            int start = document.getLineOffset(line);
            int end = start + document.getLineLength(line) - 1;
            int whiteEnd = this.findEndOfWhiteSpace(document, start, end);
            return document.get(start, whiteEnd - start);
        }
        return "";
    }

    private int getStringEnd(IDocument d, int offset, int endOffset, char ch) throws BadLocationException {
        while (offset < endOffset) {
            char curr = d.getChar(offset);
            ++offset;
            if (curr == '\\') {
                ++offset;
                continue;
            }
            if (curr != ch) continue;
            return offset;
        }
        return endOffset;
    }

    private boolean isLineDelimiter(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.endsWith((String[])delimiters, (String)txt) > -1;
        }
        return false;
    }

    private boolean isSmartMode() {
        return this.fIsSmartMode;
    }

    private void smartIndentAfterBlockDelimiter(IDocument document, DocumentCommand command) {
        if (command.text.charAt(0) == '}') {
            this.smartIndentAfterClosingBracket(document, command);
        } else if (command.text.charAt(0) == '{') {
            this.smartIndentAfterOpeningBracket(document, command);
        }
    }

    private void smartIndentAfterClosingBracket(IDocument document, DocumentCommand command) {
        try {
            int length = document.getLength();
            int cursorAt = command.offset == length ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(cursorAt);
            int lineStartsAt = document.getLineOffset(line);
            int whiteEnd = this.findEndOfWhiteSpace(document, lineStartsAt, cursorAt);
            if (whiteEnd == cursorAt) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(document, this.findMatchingOpenBracket(document, cursorAt, command.text.charAt(0))));
                replaceText.append(document.get(whiteEnd, command.offset - whiteEnd));
                replaceText.append(command.text);
                command.length += command.offset - lineStartsAt;
                command.offset = lineStartsAt;
                command.text = replaceText.toString();
            }
        }
        catch (BadLocationException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        AtlHeuristicScanner scanner = new AtlHeuristicScanner(d);
        AtlIndenter indenter = new AtlIndenter(d, scanner);
        StringBuffer indent = indenter.computeIndentation(c.offset);
        if (indent == null) {
            indent = new StringBuffer();
        }
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int p = c.offset == docLength ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(String.valueOf(c.text) + indent);
            IRegion reg = d.getLineInformation(line);
            int lineEnd = reg.getOffset() + reg.getLength();
            int contentStart = this.findEndOfWhiteSpace(d, c.offset, lineEnd);
            c.length = Math.max(contentStart - c.offset, 0);
            int start = reg.getOffset();
            ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)start, (boolean)true);
            if ("documentation".equals(region.getType())) {
                start = d.getLineInformationOfOffset(region.getOffset()).getOffset();
            }
            if (this.getBracketCount(d, start, c.offset, true) > 0 && this.closeBrace() && !this.isClosed(d, c.offset, c.length)) {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                if ((c.offset == 0 || AtlAutoIndentStrategy.computeAnonymousPosition(d, c.offset - 1, this.fPartitioning, lineEnd) == -1) && lineEnd - contentStart > 0) {
                    c.length = lineEnd - c.offset;
                    buf.append(d.get(contentStart, lineEnd - contentStart).toCharArray());
                }
                buf.append(AtlAutoIndentStrategy.getLineDelimiter(d));
                StringBuffer reference = null;
                int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuffer(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                if (reference != null) {
                    buf.append(reference);
                }
                buf.append('}');
            }
            c.text = buf.toString();
        }
        catch (BadLocationException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private boolean isClosed(IDocument d, int offset, int length) {
        return new AtlPairMatcher(IAtlLexems.BRACKETS).match(d, offset) != null;
    }

    private void smartIndentAfterOpeningBracket(IDocument document, DocumentCommand command) {
        if (command.offset < 1 || document.getLength() == 0) {
            return;
        }
        AtlHeuristicScanner scanner = new AtlHeuristicScanner(document);
        int p = command.offset == document.getLength() ? command.offset - 1 : command.offset;
        try {
            int line = document.getLineOfOffset(p);
            int lineOffset = document.getLineOffset(line);
            int pos = scanner.findNonWhitespaceBackward(p, -2);
            if (pos == -1) {
                return;
            }
            int lastLine = document.getLineOfOffset(pos);
            if (lastLine < line) {
                AtlIndenter indenter = new AtlIndenter(document, scanner);
                StringBuffer indent = indenter.computeIndentation(p, true);
                String toDelete = document.get(lineOffset, command.offset - lineOffset);
                if (indent != null && !indent.toString().equals(toDelete)) {
                    command.text = indent.append(command.text).toString();
                    command.length += command.offset - lineOffset;
                    command.offset = lineOffset;
                }
            }
        }
        catch (BadLocationException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

