/*******************************************************************************
 * Copyright (c) 2004 INRIA.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *    Freddy Allilaire (INRIA) - initial API and implementation
 *******************************************************************************/
package org.eclipse.m2m.atl.debug.core;


/**
 * Common constants for debugging.
 * 
 * @author <a href="mailto:freddy.allilaire@obeo.fr">Freddy Allilaire</a>
 */
public final class AtlDebugModelConstants {

	/** Host name. */
	public static final String HOST = "localhost"; //$NON-NLS-1$

	/** Debug target name. */
	public static final String DEBUGTARGETNAME = "Atl Debug Target"; //$NON-NLS-1$

	/** Run target name. */
	public static final String RUNTARGETNAME = "Atl Run Target"; //$NON-NLS-1$

	/** Thread name. */
	public static final String THREADNAME = "Main thread"; //$NON-NLS-1$

	/** null debug notation. */
	public static final String NULL = "<null>"; //$NON-NLS-1$

	/** key debug notation. */
	public static final String KEY = "key"; //$NON-NLS-1$

	/** value debug notation. */
	public static final String VALUE = "value"; //$NON-NLS-1$

	/** map element debug notation. */
	public static final String MAPELEMENT = "Map Element"; //$NON-NLS-1$

	/** ATL debug model identifier. */
	public static final String ATL_DEBUG_MODEL_ID = "org.eclipse.m2m.atl.adt.debug"; //$NON-NLS-1$
	
	/**
	 * Utility class.
	 */
	private AtlDebugModelConstants() {
	}
	
	
}
