/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.launcher;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2m.atl.common.AtlNbCharFile;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class EMFTVMConsoleTracker
implements IPatternMatchListenerDelegate {
    protected TextConsole console;

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            URI moduleURI;
            IFile file;
            int offset = event.getOffset() + 1;
            int length = event.getLength() - 2;
            IDocument document = this.console.getDocument();
            String info = document.get(offset, length);
            if (info.contains(":/") && (file = EMFTVMConsoleTracker.getFileFromModuleURI(moduleURI = URI.createURI((String)info))) != null && file.isAccessible()) {
                int lineNumber = -1;
                int fileOffset = -1;
                int fileLength = -1;
                if (moduleURI.hasFragment()) {
                    if (moduleURI.fragment().matches("\\[[0-9]*:[0-9]*-[0-9]*:[0-9]*\\]")) {
                        String location = moduleURI.fragment().substring(1, moduleURI.fragment().length() - 1);
                        lineNumber = Integer.valueOf(location.split(":")[0]);
                        AtlNbCharFile help = new AtlNbCharFile(file.getContents());
                        int[] index = help.getIndexChar(location);
                        fileOffset = index[0];
                        fileLength = index[1] - index[0];
                    } else if (moduleURI.fragment().matches("\\[[0-9]*:.*\\([0-9]*-[0-9]*\\)\\]")) {
                        String location = moduleURI.fragment().substring(1, moduleURI.fragment().length() - 1);
                        lineNumber = Integer.valueOf(location.split(":")[0]);
                        String[] offsets = location.substring(location.indexOf(40) + 1, location.lastIndexOf(41)).split("-");
                        fileOffset = Integer.valueOf(offsets[0]);
                        fileLength = Integer.valueOf(offsets[1]) + 1 - Integer.valueOf(offsets[0]);
                    } else if (moduleURI.fragment().matches("\\[[0-9]*-.*\\([0-9]*-[0-9]*\\)\\]")) {
                        String location = moduleURI.fragment().substring(1, moduleURI.fragment().length() - 1);
                        lineNumber = Integer.valueOf(location.split("-")[0]);
                        String[] offsets = location.substring(location.indexOf(40) + 1, location.lastIndexOf(41)).split("-");
                        fileOffset = Integer.valueOf(offsets[0]);
                        fileLength = Integer.valueOf(offsets[1]) + 1 - Integer.valueOf(offsets[0]);
                    }
                }
                this.console.addHyperlink((IHyperlink)new FileLink(file, null, fileOffset, fileLength, lineNumber), offset, length);
            }
        }
        catch (Throwable throwable) {}
    }

    protected static IFile getFileFromModuleURI(URI moduleURI) {
        if (moduleURI.isPlatformResource()) {
            String path = moduleURI.trimFragment().toPlatformString(true);
            IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (r instanceof IFile) {
                return (IFile)r;
            }
        }
        return null;
    }
}

