/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl.resource;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.Feature;
import org.eclipse.m2m.atl.emftvm.FeatureTag;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.InputRuleElement;
import org.eclipse.m2m.atl.emftvm.Instruction;
import org.eclipse.m2m.atl.emftvm.LineNumber;
import org.eclipse.m2m.atl.emftvm.LocalVariable;
import org.eclipse.m2m.atl.emftvm.ModelDeclaration;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.NamedElement;
import org.eclipse.m2m.atl.emftvm.Opcode;
import org.eclipse.m2m.atl.emftvm.Operation;
import org.eclipse.m2m.atl.emftvm.OutputRuleElement;
import org.eclipse.m2m.atl.emftvm.Parameter;
import org.eclipse.m2m.atl.emftvm.Rule;
import org.eclipse.m2m.atl.emftvm.RuleMode;
import org.eclipse.m2m.atl.emftvm.TypedElement;
import org.eclipse.m2m.atl.emftvm.impl.resource.ConstantPool;
import org.eclipse.m2m.atl.emftvm.impl.resource.LoadInstructionParametersSwitch;
import org.eclipse.m2m.atl.emftvm.impl.resource.SaveInstructionParametersSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFTVMResourceImpl
extends ResourceImpl {
    public static final int MAGIC_LEGACY = 1163155021;
    public static final int MAGIC_00 = 1162692180;
    public static final int MAGIC_01 = 1447886848;
    public static final int BYTECODE_VERSION = 1;
    public static final int TRACE_MODE_DEFAULT = 1;
    public static final int TRACE_MODE_UNIQUE = 2;
    protected static final EmftvmFactory FACTORY = EmftvmFactory.eINSTANCE;
    private int bytecodeVersion;

    public EMFTVMResourceImpl() {
    }

    public EMFTVMResourceImpl(URI uri) {
        super(uri);
    }

    public int getBytecodeVersion() {
        return this.bytecodeVersion;
    }

    protected void setBytecodeVersion(int bytecodeVersion) {
        this.bytecodeVersion = bytecodeVersion;
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        DataInputStream in = new DataInputStream(inputStream);
        int magic_00 = in.readInt();
        if (magic_00 == 1163155021) {
            this.setBytecodeVersion(0);
        } else {
            if (magic_00 != 1162692180) {
                throw new IOException("Wrong magic");
            }
            int magic_01 = in.readInt();
            if ((magic_01 & 0xFFFF0000) != 1447886848) {
                throw new IOException("Wrong magic");
            }
            int version = magic_01 & 0xFFFF;
            if (version > 1) {
                throw new IOException("Unsupported bytecode version: " + version);
            }
            this.setBytecodeVersion(version);
        }
        ConstantPool constants = new ConstantPool();
        constants.read(in);
        Module module = this.readModule(in, constants);
        this.getContents().add((Object)module);
    }

    private Module readModule(DataInputStream in, ConstantPool constants) throws IOException {
        Module module = FACTORY.createModule();
        module.setName((String)constants.get(in.readInt()));
        module.setSourceName((String)constants.get(in.readInt()));
        EMFTVMResourceImpl.readModelDeclarations(in, constants, module.getInputModels());
        EMFTVMResourceImpl.readModelDeclarations(in, constants, module.getInoutModels());
        EMFTVMResourceImpl.readModelDeclarations(in, constants, module.getOutputModels());
        EList<String> imports = module.getImports();
        int itsize = in.readInt();
        int i = 0;
        while (i < itsize) {
            imports.add((Object)((String)constants.get(in.readInt())));
            ++i;
        }
        EMFTVMResourceImpl.readFeatures(in, constants, module.getFeatures());
        this.readRules(in, constants, module.getRules());
        return module;
    }

    private static void readModelDeclarations(DataInputStream in, ConstantPool constants, EList<ModelDeclaration> models) throws IOException {
        int msize = in.readInt();
        int i = 0;
        while (i < msize) {
            ModelDeclaration model = FACTORY.createModelDeclaration();
            models.add((Object)model);
            model.setModelName((String)constants.get(in.readInt()));
            model.setMetaModelName((String)constants.get(in.readInt()));
            ++i;
        }
    }

    private static void readFields(DataInputStream in, ConstantPool constants, EList<Field> fields) throws IOException {
        int fsize = in.readInt();
        int i = 0;
        while (i < fsize) {
            Field f;
            int tag = in.readInt();
            switch (tag) {
                case 0: {
                    f = FACTORY.createField();
                    break;
                }
                case 1: {
                    f = FACTORY.createField();
                    f.setStatic(true);
                    break;
                }
                default: {
                    throw new UnsupportedEncodingException(String.format("Unsupported feature type: %d", tag));
                }
            }
            fields.add((Object)f);
            EMFTVMResourceImpl.readField(in, constants, f);
            ++i;
        }
    }

    private static void readFeatures(DataInputStream in, ConstantPool constants, EList<Feature> features) throws IOException {
        int fsize = in.readInt();
        int i = 0;
        while (i < fsize) {
            Feature f;
            int tag = in.readInt();
            switch (tag) {
                case 0: {
                    f = FACTORY.createField();
                    break;
                }
                case 1: {
                    f = FACTORY.createField();
                    f.setStatic(true);
                    break;
                }
                case 2: {
                    f = FACTORY.createOperation();
                    break;
                }
                case 3: {
                    f = FACTORY.createOperation();
                    f.setStatic(true);
                    break;
                }
                case 4: {
                    f = FACTORY.createOperation();
                    ((Operation)f).setQuery(true);
                    break;
                }
                case 5: {
                    f = FACTORY.createOperation();
                    f.setStatic(true);
                    ((Operation)f).setQuery(true);
                    break;
                }
                default: {
                    throw new UnsupportedEncodingException(String.format("Unsupported feature type: %d", tag));
                }
            }
            features.add((Object)f);
            assert (f instanceof Field || f instanceof Operation);
            if (f instanceof Field) {
                EMFTVMResourceImpl.readField(in, constants, (Field)f);
            } else {
                EMFTVMResourceImpl.readOperation(in, constants, (Operation)f);
            }
            ++i;
        }
    }

    private static void readNamedElement(DataInputStream in, ConstantPool constants, NamedElement namedElement) throws IOException {
        namedElement.setName((String)constants.get(in.readInt()));
    }

    private static void readTypedElement(DataInputStream in, ConstantPool constants, TypedElement typedElement) throws IOException {
        EMFTVMResourceImpl.readNamedElement(in, constants, typedElement);
        typedElement.setType((String)constants.get(in.readInt()));
        typedElement.setTypeModel((String)constants.get(in.readInt()));
    }

    private static void readFeature(DataInputStream in, ConstantPool constants, Feature feature) throws IOException {
        EMFTVMResourceImpl.readTypedElement(in, constants, feature);
        feature.setContext((String)constants.get(in.readInt()));
        feature.setContextModel((String)constants.get(in.readInt()));
    }

    private static void readField(DataInputStream in, ConstantPool constants, Field field) throws IOException {
        EMFTVMResourceImpl.readFeature(in, constants, field);
        CodeBlock cb = FACTORY.createCodeBlock();
        field.setInitialiser(cb);
        EMFTVMResourceImpl.readCodeBlock(in, constants, cb);
    }

    private static void readOperation(DataInputStream in, ConstantPool constants, Operation op) throws IOException {
        EMFTVMResourceImpl.readFeature(in, constants, op);
        EMFTVMResourceImpl.readParameters(in, constants, op.getParameters());
        CodeBlock cb = FACTORY.createCodeBlock();
        op.setBody(cb);
        EMFTVMResourceImpl.readCodeBlock(in, constants, cb);
    }

    private static void readCodeBlock(DataInputStream in, ConstantPool constants, CodeBlock cb) throws IOException {
        int maxLocals = in.readInt();
        int maxStack = in.readInt();
        EMFTVMResourceImpl.readLocalVariables(in, constants, cb.getLocalVariables());
        EMFTVMResourceImpl.readLineNumbers(in, cb.getLineNumbers());
        int nestedSize = in.readInt();
        EList<CodeBlock> nested = cb.getNested();
        int i = 0;
        while (i < nestedSize) {
            CodeBlock nestedcode = FACTORY.createCodeBlock();
            nested.add((Object)nestedcode);
            EMFTVMResourceImpl.readCodeBlock(in, constants, nestedcode);
            ++i;
        }
        EMFTVMResourceImpl.readInstructions(in, constants, cb);
        cb.setMaxLocals(maxLocals);
        cb.setMaxStack(maxStack);
    }

    private static void readParameters(DataInputStream in, ConstantPool constants, EList<Parameter> parameters) throws IOException {
        int ptsize = in.readInt();
        int i = 0;
        while (i < ptsize) {
            Parameter par = FACTORY.createParameter();
            parameters.add((Object)par);
            EMFTVMResourceImpl.readTypedElement(in, constants, par);
            ++i;
        }
    }

    private static void readInstructions(DataInputStream in, ConstantPool constants, CodeBlock cb) throws IOException {
        LoadInstructionParametersSwitch loadParms = new LoadInstructionParametersSwitch(in, constants);
        int isize = in.readInt();
        EList<Instruction> code = cb.getCode();
        int i = 0;
        while (i < isize) {
            int lineNumber = in.readInt();
            Instruction instr = FACTORY.createInstruction(Opcode.get(in.readInt()));
            code.add((Object)instr);
            if (lineNumber > -1) {
                instr.setLineNumber((LineNumber)cb.getLineNumbers().get(lineNumber));
            }
            loadParms.doSwitch(instr);
            ++i;
        }
    }

    private static void readLineNumbers(DataInputStream in, EList<LineNumber> lineNumbers) throws IOException {
        int lnsize = in.readInt();
        int i = 0;
        while (i < lnsize) {
            LineNumber ln = FACTORY.createLineNumber();
            lineNumbers.add((Object)ln);
            ln.setStartLine(in.readInt());
            ln.setStartColumn(in.readInt());
            ln.setEndLine(in.readInt());
            ln.setEndColumn(in.readInt());
            ln.setStartChar(in.readInt());
            ln.setEndChar(in.readInt());
            ++i;
        }
    }

    private static void readLocalVariables(DataInputStream in, ConstantPool constants, EList<LocalVariable> localVars) throws IOException {
        int lvsize = in.readInt();
        int i = 0;
        while (i < lvsize) {
            LocalVariable lv = FACTORY.createLocalVariable();
            localVars.add((Object)lv);
            lv.setSlot(in.readInt());
            EMFTVMResourceImpl.readTypedElement(in, constants, lv);
            lv.setStartInstructionIndex(in.readInt());
            lv.setEndInstructionIndex(in.readInt());
            ++i;
        }
    }

    private void readRules(DataInputStream in, ConstantPool constants, EList<Rule> rules) throws IOException {
        int rtsize = in.readInt();
        int i = 0;
        while (i < rtsize) {
            Rule rule = FACTORY.createRule();
            rules.add((Object)rule);
            EMFTVMResourceImpl.readNamedElement(in, constants, rule);
            rule.setMode(RuleMode.get(in.readInt()));
            rule.setAbstract(in.readInt() == 1);
            int traceMode = in.readInt();
            rule.setDefault((traceMode & 1) == 1);
            rule.setUnique((traceMode & 2) == 2);
            rule.setDistinctElements(in.readInt() == 1);
            this.readInputRuleElements(in, constants, rule.getInputElements());
            EMFTVMResourceImpl.readOutputRuleElements(in, constants, rule);
            EMFTVMResourceImpl.readSuperRules(in, constants, rule.getSuperRules());
            EMFTVMResourceImpl.readFields(in, constants, rule.getFields());
            if (in.readInt() > 0) {
                CodeBlock matcher = FACTORY.createCodeBlock();
                rule.setMatcher(matcher);
                EMFTVMResourceImpl.readCodeBlock(in, constants, matcher);
            }
            if (in.readInt() > 0) {
                CodeBlock applier = FACTORY.createCodeBlock();
                rule.setApplier(applier);
                EMFTVMResourceImpl.readCodeBlock(in, constants, applier);
            }
            if (in.readInt() > 0) {
                CodeBlock postApply = FACTORY.createCodeBlock();
                rule.setPostApply(postApply);
                EMFTVMResourceImpl.readCodeBlock(in, constants, postApply);
            }
            ++i;
        }
    }

    private void readInputRuleElements(DataInputStream in, ConstantPool constants, EList<InputRuleElement> elements) throws IOException {
        int esize = in.readInt();
        int i = 0;
        while (i < esize) {
            InputRuleElement ire = FACTORY.createInputRuleElement();
            elements.add((Object)ire);
            EMFTVMResourceImpl.readTypedElement(in, constants, ire);
            if (this.getBytecodeVersion() >= 1) {
                ire.setMapsToSelf(in.readInt() > 0);
            }
            int iemsize = in.readInt();
            EList<String> models = ire.getModels();
            int j = 0;
            while (j < iemsize) {
                models.add((Object)((String)constants.get(in.readInt())));
                ++j;
            }
            if (in.readInt() > 0) {
                CodeBlock binding = FACTORY.createCodeBlock();
                ire.setBinding(binding);
                EMFTVMResourceImpl.readCodeBlock(in, constants, binding);
            }
            ++i;
        }
    }

    private static void readOutputRuleElements(DataInputStream in, ConstantPool constants, Rule rule) throws IOException {
        EList<OutputRuleElement> elements = rule.getOutputElements();
        int esize = in.readInt();
        int i = 0;
        while (i < esize) {
            OutputRuleElement ore = FACTORY.createOutputRuleElement();
            elements.add((Object)ore);
            EMFTVMResourceImpl.readTypedElement(in, constants, ore);
            ore.getModels().add((Object)((String)constants.get(in.readInt())));
            EList<InputRuleElement> mapsTo = ore.getMapsTo();
            int mtsize = in.readInt();
            int j = 0;
            while (j < mtsize) {
                String inputElementName = (String)constants.get(in.readInt());
                boolean found = false;
                for (InputRuleElement ire : rule.getInputElements()) {
                    if (!inputElementName.equals(ire.getName())) continue;
                    mapsTo.add((Object)ire);
                    found = true;
                }
                if (!found) {
                    throw new IOException(String.format("Source element mapping %s not found for output element %s", inputElementName, ore));
                }
                ++j;
            }
            ++i;
        }
    }

    private static void readSuperRules(DataInputStream in, ConstantPool constants, EList<String> superRules) throws IOException {
        int srsize = in.readInt();
        int i = 0;
        while (i < srsize) {
            superRules.add((Object)((String)constants.get(in.readInt())));
            ++i;
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        DataOutputStream out = new DataOutputStream(outputStream);
        out.writeInt(1162692180);
        out.writeInt(1447886849);
        Module module = this.findModule();
        ConstantPool constants = new ConstantPool();
        constants.createConstants(module);
        constants.write(out);
        EMFTVMResourceImpl.writeModule(out, constants, module);
    }

    protected Module findModule() throws IOException {
        Module module = null;
        for (EObject object : this.getContents()) {
            if (!(object instanceof Module)) continue;
            if (module == null) {
                module = (Module)object;
                continue;
            }
            throw new IOException("More than one Module found in Resource");
        }
        if (module == null) {
            throw new IOException("No Module found in Resource");
        }
        return module;
    }

    private static void writeModule(DataOutputStream out, ConstantPool constants, Module module) throws IOException {
        out.writeInt(constants.indexOf(module.getName()));
        out.writeInt(constants.indexOf(module.getSourceName()));
        EMFTVMResourceImpl.writeModelDeclarations(out, constants, module.getInputModels());
        EMFTVMResourceImpl.writeModelDeclarations(out, constants, module.getInoutModels());
        EMFTVMResourceImpl.writeModelDeclarations(out, constants, module.getOutputModels());
        EList<String> imports = module.getImports();
        out.writeInt(imports.size());
        for (String i : imports) {
            out.writeInt(constants.indexOf(i));
        }
        EList<Feature> features = module.getFeatures();
        EMFTVMResourceImpl.writeFeatures(out, constants, features);
        EMFTVMResourceImpl.writeRules(out, constants, module.getRules());
    }

    private static void writeModelDeclarations(DataOutputStream out, ConstantPool constants, EList<ModelDeclaration> models) throws IOException {
        out.writeInt(models.size());
        for (ModelDeclaration model : models) {
            out.writeInt(constants.indexOf(model.getModelName()));
            out.writeInt(constants.indexOf(model.getMetaModelName()));
        }
    }

    private static void writeFields(DataOutputStream out, ConstantPool constants, EList<Field> fields) throws IOException {
        out.writeInt(fields.size());
        for (Field field : fields) {
            out.writeInt(field.isStatic() ? 1 : 0);
            EMFTVMResourceImpl.writeFeature(out, constants, field);
            if (field.getInitialiser() == null) {
                field.setInitialiser(FACTORY.createCodeBlock());
            }
            EMFTVMResourceImpl.writeCodeBlock(out, constants, field.getInitialiser());
        }
    }

    private static void writeFeatures(DataOutputStream out, ConstantPool constants, EList<Feature> features) throws IOException {
        out.writeInt(features.size());
        for (Feature f : features) {
            switch (f.eClass().getClassifierID()) {
                case 6: {
                    Field field = (Field)f;
                    out.writeInt(f.isStatic() ? 1 : 0);
                    EMFTVMResourceImpl.writeFeature(out, constants, field);
                    if (field.getInitialiser() == null) {
                        field.setInitialiser(FACTORY.createCodeBlock());
                    }
                    EMFTVMResourceImpl.writeCodeBlock(out, constants, field.getInitialiser());
                    break;
                }
                case 7: {
                    FeatureTag tag;
                    Operation op = (Operation)f;
                    int opflags = (f.isStatic() ? 1 : 0) + (((Operation)f).isQuery() ? 2 : 0);
                    switch (opflags) {
                        case 0: {
                            tag = FeatureTag.OPERATION;
                            break;
                        }
                        case 1: {
                            tag = FeatureTag.STATIC_OPERATION;
                            break;
                        }
                        case 2: {
                            tag = FeatureTag.QUERY_OPERATION;
                            break;
                        }
                        case 3: {
                            tag = FeatureTag.STATIC_QUERY_OPERATION;
                            break;
                        }
                        default: {
                            throw new UnsupportedEncodingException();
                        }
                    }
                    out.writeInt(tag.getValue());
                    EMFTVMResourceImpl.writeFeature(out, constants, op);
                    EMFTVMResourceImpl.writeParameters(out, constants, op.getParameters());
                    if (op.getBody() == null) {
                        op.setBody(FACTORY.createCodeBlock());
                    }
                    EMFTVMResourceImpl.writeCodeBlock(out, constants, op.getBody());
                    break;
                }
                default: {
                    throw new UnsupportedEncodingException(String.format("Unknown feature tag for feature %s", f));
                }
            }
        }
    }

    private static void writeNamedElement(DataOutputStream out, ConstantPool constants, NamedElement namedElement) throws IOException {
        out.writeInt(constants.indexOf(namedElement.getName()));
    }

    private static void writeTypedElement(DataOutputStream out, ConstantPool constants, TypedElement typedElement) throws IOException {
        EMFTVMResourceImpl.writeNamedElement(out, constants, typedElement);
        out.writeInt(constants.indexOf(typedElement.getType()));
        out.writeInt(constants.indexOf(typedElement.getTypeModel()));
    }

    private static void writeFeature(DataOutputStream out, ConstantPool constants, Feature feature) throws IOException {
        EMFTVMResourceImpl.writeTypedElement(out, constants, feature);
        out.writeInt(constants.indexOf(feature.getContext()));
        out.writeInt(constants.indexOf(feature.getContextModel()));
    }

    private static void writeCodeBlock(DataOutputStream out, ConstantPool constants, CodeBlock cb) throws IOException {
        out.writeInt(cb.getMaxLocals());
        out.writeInt(cb.getMaxStack());
        EMFTVMResourceImpl.writeLocalVariables(out, constants, cb);
        EMFTVMResourceImpl.writeLineNumbers(out, cb);
        EList<CodeBlock> nested = cb.getNested();
        out.writeInt(nested.size());
        for (CodeBlock nestedcode : nested) {
            EMFTVMResourceImpl.writeCodeBlock(out, constants, nestedcode);
        }
        EMFTVMResourceImpl.writeInstructions(out, constants, cb);
    }

    private static void writeParameters(DataOutputStream out, ConstantPool constants, EList<Parameter> parameters) throws IOException {
        out.writeInt(parameters.size());
        for (Parameter p : parameters) {
            EMFTVMResourceImpl.writeTypedElement(out, constants, p);
        }
    }

    private static void writeInstructions(DataOutputStream out, ConstantPool constants, CodeBlock cb) throws IOException {
        SaveInstructionParametersSwitch saveParms = new SaveInstructionParametersSwitch(out, constants);
        EList<Instruction> code = cb.getCode();
        EList<LineNumber> lns = cb.getLineNumbers();
        out.writeInt(code.size());
        for (Instruction i : code) {
            LineNumber ln = i.getLineNumber();
            if (ln != null) {
                out.writeInt(lns.indexOf((Object)ln));
            } else {
                out.writeInt(-1);
            }
            out.writeInt(i.getOpcode().getValue());
            saveParms.doSwitch(i);
        }
    }

    private static void writeLineNumbers(DataOutputStream out, CodeBlock cb) throws IOException {
        EList<LineNumber> lineNumbers = cb.getLineNumbers();
        out.writeInt(lineNumbers.size());
        for (LineNumber l : lineNumbers) {
            out.writeInt(l.getStartLine());
            out.writeInt(l.getStartColumn());
            out.writeInt(l.getEndLine());
            out.writeInt(l.getEndColumn());
            out.writeInt(l.getStartChar());
            out.writeInt(l.getEndChar());
        }
    }

    private static void writeLocalVariables(DataOutputStream out, ConstantPool constants, CodeBlock cb) throws IOException {
        EList<LocalVariable> localVars = cb.getLocalVariables();
        out.writeInt(localVars.size());
        for (LocalVariable lv : localVars) {
            out.writeInt(lv.getSlot());
            EMFTVMResourceImpl.writeTypedElement(out, constants, lv);
            out.writeInt(lv.getStartInstructionIndex());
            out.writeInt(lv.getEndInstructionIndex());
        }
    }

    private static void writeRules(DataOutputStream out, ConstantPool constants, EList<Rule> rules) throws IOException {
        out.writeInt(rules.size());
        for (Rule r : rules) {
            EMFTVMResourceImpl.writeNamedElement(out, constants, r);
            out.writeInt(r.getMode().getValue());
            out.writeInt(r.isAbstract() ? 1 : 0);
            int traceMode = 0;
            if (r.isDefault()) {
                ++traceMode;
            }
            if (r.isUnique()) {
                traceMode += 2;
            }
            out.writeInt(traceMode);
            out.writeInt(r.isDistinctElements() ? 1 : 0);
            EMFTVMResourceImpl.writeInputRuleElements(out, constants, r.getInputElements());
            EMFTVMResourceImpl.writeOutputRuleElements(out, constants, r);
            EMFTVMResourceImpl.writeSuperRules(out, constants, r.getSuperRules());
            EMFTVMResourceImpl.writeFields(out, constants, r.getFields());
            if (r.getMatcher() == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                EMFTVMResourceImpl.writeCodeBlock(out, constants, r.getMatcher());
            }
            if (r.getApplier() == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                EMFTVMResourceImpl.writeCodeBlock(out, constants, r.getApplier());
            }
            if (r.getPostApply() == null) {
                out.writeInt(0);
                continue;
            }
            out.writeInt(1);
            EMFTVMResourceImpl.writeCodeBlock(out, constants, r.getPostApply());
        }
    }

    private static void writeInputRuleElements(DataOutputStream out, ConstantPool constants, EList<InputRuleElement> elements) throws IOException {
        out.writeInt(elements.size());
        for (InputRuleElement ire : elements) {
            EMFTVMResourceImpl.writeTypedElement(out, constants, ire);
            out.writeInt(ire.isMapsToSelf() ? 1 : 0);
            EList<String> models = ire.getModels();
            out.writeInt(models.size());
            for (String model : models) {
                out.writeInt(constants.indexOf(model));
            }
            if (ire.getBinding() == null) {
                out.writeInt(0);
                continue;
            }
            out.writeInt(1);
            EMFTVMResourceImpl.writeCodeBlock(out, constants, ire.getBinding());
        }
    }

    private static void writeOutputRuleElements(DataOutputStream out, ConstantPool constants, Rule rule) throws IOException {
        EList<OutputRuleElement> elements = rule.getOutputElements();
        out.writeInt(elements.size());
        for (OutputRuleElement ore : elements) {
            EMFTVMResourceImpl.writeTypedElement(out, constants, ore);
            if (ore.getModels().size() != 1) {
                throw new IOException(String.format("Rule output element %s must have exactly one model", ore));
            }
            out.writeInt(constants.indexOf(ore.getModels().get(0)));
            out.writeInt(ore.getMapsTo().size());
            for (InputRuleElement ire : ore.getMapsTo()) {
                if (ire.getInputFor() != ore.getOutputFor()) {
                    throw new IOException(String.format("Source element mapping for output element %s must lie within the same rule", ore));
                }
                out.writeInt(constants.indexOf(ire.getName()));
            }
        }
    }

    private static void writeSuperRules(DataOutputStream out, ConstantPool constants, EList<String> superRules) throws IOException {
        out.writeInt(superRules.size());
        for (String sr : superRules) {
            out.writeInt(constants.indexOf(sr));
        }
    }
}

