/*******************************************************************************
 * Copyright (c) 2011 Vrije Universiteit Brussel.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Dennis Wagelaar, Vrije Universiteit Brussel - initial API and
 *         implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.m2m.atl.emftvm.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.m2m.atl.emftvm.util.EmftvmAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * @author <a href="mailto:dennis.wagelaar@vub.ac.be">Dennis Wagelaar</a>
 * <!-- end-user-doc -->
 * @generated
 */
public class EmftvmItemProviderAdapterFactory extends EmftvmAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EmftvmItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Module} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModuleItemProvider moduleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Module}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModuleAdapter() {
		if (moduleItemProvider == null) {
			moduleItemProvider = new ModuleItemProvider(this);
		}

		return moduleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.ModelDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelDeclarationItemProvider modelDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.ModelDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModelDeclarationAdapter() {
		if (modelDeclarationItemProvider == null) {
			modelDeclarationItemProvider = new ModelDeclarationItemProvider(this);
		}

		return modelDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Field} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FieldItemProvider fieldItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Field}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFieldAdapter() {
		if (fieldItemProvider == null) {
			fieldItemProvider = new FieldItemProvider(this);
		}

		return fieldItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Operation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperationItemProvider operationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Operation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperationAdapter() {
		if (operationItemProvider == null) {
			operationItemProvider = new OperationItemProvider(this);
		}

		return operationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Parameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterItemProvider parameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Parameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterAdapter() {
		if (parameterItemProvider == null) {
			parameterItemProvider = new ParameterItemProvider(this);
		}

		return parameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.LineNumber} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LineNumberItemProvider lineNumberItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.LineNumber}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLineNumberAdapter() {
		if (lineNumberItemProvider == null) {
			lineNumberItemProvider = new LineNumberItemProvider(this);
		}

		return lineNumberItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.LocalVariable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LocalVariableItemProvider localVariableItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.LocalVariable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLocalVariableAdapter() {
		if (localVariableItemProvider == null) {
			localVariableItemProvider = new LocalVariableItemProvider(this);
		}

		return localVariableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Rule} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RuleItemProvider ruleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Rule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRuleAdapter() {
		if (ruleItemProvider == null) {
			ruleItemProvider = new RuleItemProvider(this);
		}

		return ruleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.InputRuleElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InputRuleElementItemProvider inputRuleElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.InputRuleElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInputRuleElementAdapter() {
		if (inputRuleElementItemProvider == null) {
			inputRuleElementItemProvider = new InputRuleElementItemProvider(this);
		}

		return inputRuleElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.OutputRuleElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OutputRuleElementItemProvider outputRuleElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.OutputRuleElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOutputRuleElementAdapter() {
		if (outputRuleElementItemProvider == null) {
			outputRuleElementItemProvider = new OutputRuleElementItemProvider(this);
		}

		return outputRuleElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.CodeBlock} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CodeBlockItemProvider codeBlockItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.CodeBlock}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCodeBlockAdapter() {
		if (codeBlockItemProvider == null) {
			codeBlockItemProvider = new CodeBlockItemProvider(this);
		}

		return codeBlockItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Push} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PushItemProvider pushItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Push}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPushAdapter() {
		if (pushItemProvider == null) {
			pushItemProvider = new PushItemProvider(this);
		}

		return pushItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Pusht} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PushtItemProvider pushtItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Pusht}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPushtAdapter() {
		if (pushtItemProvider == null) {
			pushtItemProvider = new PushtItemProvider(this);
		}

		return pushtItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Pushf} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PushfItemProvider pushfItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Pushf}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPushfAdapter() {
		if (pushfItemProvider == null) {
			pushfItemProvider = new PushfItemProvider(this);
		}

		return pushfItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Pop} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PopItemProvider popItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Pop}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPopAdapter() {
		if (popItemProvider == null) {
			popItemProvider = new PopItemProvider(this);
		}

		return popItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Load} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LoadItemProvider loadItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Load}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLoadAdapter() {
		if (loadItemProvider == null) {
			loadItemProvider = new LoadItemProvider(this);
		}

		return loadItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Store} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StoreItemProvider storeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Store}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStoreAdapter() {
		if (storeItemProvider == null) {
			storeItemProvider = new StoreItemProvider(this);
		}

		return storeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Set} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SetItemProvider setItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Set}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSetAdapter() {
		if (setItemProvider == null) {
			setItemProvider = new SetItemProvider(this);
		}

		return setItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Get} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GetItemProvider getItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Get}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGetAdapter() {
		if (getItemProvider == null) {
			getItemProvider = new GetItemProvider(this);
		}

		return getItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.GetTrans} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GetTransItemProvider getTransItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.GetTrans}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGetTransAdapter() {
		if (getTransItemProvider == null) {
			getTransItemProvider = new GetTransItemProvider(this);
		}

		return getTransItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.SetStatic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SetStaticItemProvider setStaticItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.SetStatic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSetStaticAdapter() {
		if (setStaticItemProvider == null) {
			setStaticItemProvider = new SetStaticItemProvider(this);
		}

		return setStaticItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.GetStatic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GetStaticItemProvider getStaticItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.GetStatic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGetStaticAdapter() {
		if (getStaticItemProvider == null) {
			getStaticItemProvider = new GetStaticItemProvider(this);
		}

		return getStaticItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Findtype} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FindtypeItemProvider findtypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Findtype}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFindtypeAdapter() {
		if (findtypeItemProvider == null) {
			findtypeItemProvider = new FindtypeItemProvider(this);
		}

		return findtypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.FindtypeS} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FindtypeSItemProvider findtypeSItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.FindtypeS}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFindtypeSAdapter() {
		if (findtypeSItemProvider == null) {
			findtypeSItemProvider = new FindtypeSItemProvider(this);
		}

		return findtypeSItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.New} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NewItemProvider newItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.New}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNewAdapter() {
		if (newItemProvider == null) {
			newItemProvider = new NewItemProvider(this);
		}

		return newItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.NewS} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NewSItemProvider newSItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.NewS}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNewSAdapter() {
		if (newSItemProvider == null) {
			newSItemProvider = new NewSItemProvider(this);
		}

		return newSItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Delete} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeleteItemProvider deleteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Delete}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeleteAdapter() {
		if (deleteItemProvider == null) {
			deleteItemProvider = new DeleteItemProvider(this);
		}

		return deleteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Dup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DupItemProvider dupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Dup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDupAdapter() {
		if (dupItemProvider == null) {
			dupItemProvider = new DupItemProvider(this);
		}

		return dupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.DupX1} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DupX1ItemProvider dupX1ItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.DupX1}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDupX1Adapter() {
		if (dupX1ItemProvider == null) {
			dupX1ItemProvider = new DupX1ItemProvider(this);
		}

		return dupX1ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Swap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SwapItemProvider swapItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Swap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSwapAdapter() {
		if (swapItemProvider == null) {
			swapItemProvider = new SwapItemProvider(this);
		}

		return swapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.SwapX1} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SwapX1ItemProvider swapX1ItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.SwapX1}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSwapX1Adapter() {
		if (swapX1ItemProvider == null) {
			swapX1ItemProvider = new SwapX1ItemProvider(this);
		}

		return swapX1ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.If} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IfItemProvider ifItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.If}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIfAdapter() {
		if (ifItemProvider == null) {
			ifItemProvider = new IfItemProvider(this);
		}

		return ifItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Ifn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IfnItemProvider ifnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Ifn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIfnAdapter() {
		if (ifnItemProvider == null) {
			ifnItemProvider = new IfnItemProvider(this);
		}

		return ifnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Goto} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GotoItemProvider gotoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Goto}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGotoAdapter() {
		if (gotoItemProvider == null) {
			gotoItemProvider = new GotoItemProvider(this);
		}

		return gotoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Iterate} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IterateItemProvider iterateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Iterate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIterateAdapter() {
		if (iterateItemProvider == null) {
			iterateItemProvider = new IterateItemProvider(this);
		}

		return iterateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Enditerate} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnditerateItemProvider enditerateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Enditerate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnditerateAdapter() {
		if (enditerateItemProvider == null) {
			enditerateItemProvider = new EnditerateItemProvider(this);
		}

		return enditerateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Invoke} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvokeItemProvider invokeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Invoke}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInvokeAdapter() {
		if (invokeItemProvider == null) {
			invokeItemProvider = new InvokeItemProvider(this);
		}

		return invokeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.InvokeSuper} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvokeSuperItemProvider invokeSuperItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.InvokeSuper}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInvokeSuperAdapter() {
		if (invokeSuperItemProvider == null) {
			invokeSuperItemProvider = new InvokeSuperItemProvider(this);
		}

		return invokeSuperItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.InvokeStatic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvokeStaticItemProvider invokeStaticItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.InvokeStatic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInvokeStaticAdapter() {
		if (invokeStaticItemProvider == null) {
			invokeStaticItemProvider = new InvokeStaticItemProvider(this);
		}

		return invokeStaticItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Allinst} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AllinstItemProvider allinstItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Allinst}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAllinstAdapter() {
		if (allinstItemProvider == null) {
			allinstItemProvider = new AllinstItemProvider(this);
		}

		return allinstItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.AllinstIn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AllinstInItemProvider allinstInItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.AllinstIn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAllinstInAdapter() {
		if (allinstInItemProvider == null) {
			allinstInItemProvider = new AllinstInItemProvider(this);
		}

		return allinstInItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Match} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MatchItemProvider matchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Match}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMatchAdapter() {
		if (matchItemProvider == null) {
			matchItemProvider = new MatchItemProvider(this);
		}

		return matchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.MatchS} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MatchSItemProvider matchSItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.MatchS}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMatchSAdapter() {
		if (matchSItemProvider == null) {
			matchSItemProvider = new MatchSItemProvider(this);
		}

		return matchSItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Add} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AddItemProvider addItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Add}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAddAdapter() {
		if (addItemProvider == null) {
			addItemProvider = new AddItemProvider(this);
		}

		return addItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Remove} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RemoveItemProvider removeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Remove}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRemoveAdapter() {
		if (removeItemProvider == null) {
			removeItemProvider = new RemoveItemProvider(this);
		}

		return removeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Insert} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InsertItemProvider insertItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Insert}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInsertAdapter() {
		if (insertItemProvider == null) {
			insertItemProvider = new InsertItemProvider(this);
		}

		return insertItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.GetSuper} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GetSuperItemProvider getSuperItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.GetSuper}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGetSuperAdapter() {
		if (getSuperItemProvider == null) {
			getSuperItemProvider = new GetSuperItemProvider(this);
		}

		return getSuperItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Return} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReturnItemProvider returnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Return}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReturnAdapter() {
		if (returnItemProvider == null) {
			returnItemProvider = new ReturnItemProvider(this);
		}

		return returnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Getcb} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GetcbItemProvider getcbItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Getcb}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGetcbAdapter() {
		if (getcbItemProvider == null) {
			getcbItemProvider = new GetcbItemProvider(this);
		}

		return getcbItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.InvokeAllCbs} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvokeAllCbsItemProvider invokeAllCbsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.InvokeAllCbs}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInvokeAllCbsAdapter() {
		if (invokeAllCbsItemProvider == null) {
			invokeAllCbsItemProvider = new InvokeAllCbsItemProvider(this);
		}

		return invokeAllCbsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.InvokeCb} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvokeCbItemProvider invokeCbItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.InvokeCb}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInvokeCbAdapter() {
		if (invokeCbItemProvider == null) {
			invokeCbItemProvider = new InvokeCbItemProvider(this);
		}

		return invokeCbItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.InvokeCbS} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvokeCbSItemProvider invokeCbSItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.InvokeCbS}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInvokeCbSAdapter() {
		if (invokeCbSItemProvider == null) {
			invokeCbSItemProvider = new InvokeCbSItemProvider(this);
		}

		return invokeCbSItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Not} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NotItemProvider notItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Not}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNotAdapter() {
		if (notItemProvider == null) {
			notItemProvider = new NotItemProvider(this);
		}

		return notItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.And} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AndItemProvider andItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.And}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAndAdapter() {
		if (andItemProvider == null) {
			andItemProvider = new AndItemProvider(this);
		}

		return andItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Or} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrItemProvider orItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Or}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOrAdapter() {
		if (orItemProvider == null) {
			orItemProvider = new OrItemProvider(this);
		}

		return orItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Xor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XorItemProvider xorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Xor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXorAdapter() {
		if (xorItemProvider == null) {
			xorItemProvider = new XorItemProvider(this);
		}

		return xorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Implies} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImpliesItemProvider impliesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Implies}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImpliesAdapter() {
		if (impliesItemProvider == null) {
			impliesItemProvider = new ImpliesItemProvider(this);
		}

		return impliesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Ifte} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IfteItemProvider ifteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Ifte}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIfteAdapter() {
		if (ifteItemProvider == null) {
			ifteItemProvider = new IfteItemProvider(this);
		}

		return ifteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Isnull} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IsnullItemProvider isnullItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Isnull}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIsnullAdapter() {
		if (isnullItemProvider == null) {
			isnullItemProvider = new IsnullItemProvider(this);
		}

		return isnullItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Getenvtype} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GetenvtypeItemProvider getenvtypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Getenvtype}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGetenvtypeAdapter() {
		if (getenvtypeItemProvider == null) {
			getenvtypeItemProvider = new GetenvtypeItemProvider(this);
		}

		return getenvtypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.ExecEnv} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExecEnvItemProvider execEnvItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.ExecEnv}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExecEnvAdapter() {
		if (execEnvItemProvider == null) {
			execEnvItemProvider = new ExecEnvItemProvider(this);
		}

		return execEnvItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Model} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelItemProvider modelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Model}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModelAdapter() {
		if (modelItemProvider == null) {
			modelItemProvider = new ModelItemProvider(this);
		}

		return modelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.m2m.atl.emftvm.Metamodel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MetamodelItemProvider metamodelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.m2m.atl.emftvm.Metamodel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMetamodelAdapter() {
		if (metamodelItemProvider == null) {
			metamodelItemProvider = new MetamodelItemProvider(this);
		}

		return metamodelItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (execEnvItemProvider != null) execEnvItemProvider.dispose();
		if (modelItemProvider != null) modelItemProvider.dispose();
		if (metamodelItemProvider != null) metamodelItemProvider.dispose();
		if (moduleItemProvider != null) moduleItemProvider.dispose();
		if (modelDeclarationItemProvider != null) modelDeclarationItemProvider.dispose();
		if (fieldItemProvider != null) fieldItemProvider.dispose();
		if (operationItemProvider != null) operationItemProvider.dispose();
		if (parameterItemProvider != null) parameterItemProvider.dispose();
		if (lineNumberItemProvider != null) lineNumberItemProvider.dispose();
		if (localVariableItemProvider != null) localVariableItemProvider.dispose();
		if (ruleItemProvider != null) ruleItemProvider.dispose();
		if (inputRuleElementItemProvider != null) inputRuleElementItemProvider.dispose();
		if (outputRuleElementItemProvider != null) outputRuleElementItemProvider.dispose();
		if (codeBlockItemProvider != null) codeBlockItemProvider.dispose();
		if (pushItemProvider != null) pushItemProvider.dispose();
		if (pushtItemProvider != null) pushtItemProvider.dispose();
		if (pushfItemProvider != null) pushfItemProvider.dispose();
		if (popItemProvider != null) popItemProvider.dispose();
		if (loadItemProvider != null) loadItemProvider.dispose();
		if (storeItemProvider != null) storeItemProvider.dispose();
		if (setItemProvider != null) setItemProvider.dispose();
		if (getItemProvider != null) getItemProvider.dispose();
		if (getTransItemProvider != null) getTransItemProvider.dispose();
		if (setStaticItemProvider != null) setStaticItemProvider.dispose();
		if (getStaticItemProvider != null) getStaticItemProvider.dispose();
		if (findtypeItemProvider != null) findtypeItemProvider.dispose();
		if (findtypeSItemProvider != null) findtypeSItemProvider.dispose();
		if (newItemProvider != null) newItemProvider.dispose();
		if (newSItemProvider != null) newSItemProvider.dispose();
		if (deleteItemProvider != null) deleteItemProvider.dispose();
		if (dupItemProvider != null) dupItemProvider.dispose();
		if (dupX1ItemProvider != null) dupX1ItemProvider.dispose();
		if (swapItemProvider != null) swapItemProvider.dispose();
		if (swapX1ItemProvider != null) swapX1ItemProvider.dispose();
		if (ifItemProvider != null) ifItemProvider.dispose();
		if (ifnItemProvider != null) ifnItemProvider.dispose();
		if (gotoItemProvider != null) gotoItemProvider.dispose();
		if (iterateItemProvider != null) iterateItemProvider.dispose();
		if (enditerateItemProvider != null) enditerateItemProvider.dispose();
		if (invokeItemProvider != null) invokeItemProvider.dispose();
		if (invokeSuperItemProvider != null) invokeSuperItemProvider.dispose();
		if (invokeStaticItemProvider != null) invokeStaticItemProvider.dispose();
		if (allinstItemProvider != null) allinstItemProvider.dispose();
		if (allinstInItemProvider != null) allinstInItemProvider.dispose();
		if (isnullItemProvider != null) isnullItemProvider.dispose();
		if (getenvtypeItemProvider != null) getenvtypeItemProvider.dispose();
		if (notItemProvider != null) notItemProvider.dispose();
		if (andItemProvider != null) andItemProvider.dispose();
		if (orItemProvider != null) orItemProvider.dispose();
		if (xorItemProvider != null) xorItemProvider.dispose();
		if (impliesItemProvider != null) impliesItemProvider.dispose();
		if (ifteItemProvider != null) ifteItemProvider.dispose();
		if (returnItemProvider != null) returnItemProvider.dispose();
		if (getcbItemProvider != null) getcbItemProvider.dispose();
		if (invokeAllCbsItemProvider != null) invokeAllCbsItemProvider.dispose();
		if (invokeCbItemProvider != null) invokeCbItemProvider.dispose();
		if (invokeCbSItemProvider != null) invokeCbSItemProvider.dispose();
		if (matchItemProvider != null) matchItemProvider.dispose();
		if (matchSItemProvider != null) matchSItemProvider.dispose();
		if (addItemProvider != null) addItemProvider.dispose();
		if (removeItemProvider != null) removeItemProvider.dispose();
		if (insertItemProvider != null) insertItemProvider.dispose();
		if (getSuperItemProvider != null) getSuperItemProvider.dispose();
	}

}
