/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.eclipse;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.snapshot.extension.IClassSpecificNameResolver;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.MessageUtil;

public class EclipseNameResolver {

    @Subject(value="org.eclipse.core.runtime.adaptor.EclipseClassLoader")
    public static class EclipseClassLoaderResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject s = (IObject)obj.resolveValue("hostdata.symbolicName");
            return s != null ? s.getClassSpecificName() : null;
        }
    }

    @Subject(value="org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader")
    public static class EclipseDefaultClassLoaderResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject s = (IObject)obj.resolveValue("manager.data.symbolicName");
            return s != null ? s.getClassSpecificName() : null;
        }
    }

    @Subject(value="org.eclipse.osgi.internal.loader.EquinoxClassLoader")
    public static class EquinoxClassLoaderResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject s = (IObject)obj.resolveValue("generation.revision.symbolicName");
            return s != null ? s.getClassSpecificName() : null;
        }
    }

    @Subject(value="org.osgi.framework.Version")
    public static class OSGiFrameworkVersion
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            String v;
            Object s = obj.resolveValue("versionString");
            if (s instanceof IObject && (v = ((IObject)s).getClassSpecificName()) != null) {
                return v;
            }
            Object major = obj.resolveValue("major");
            Object minor = obj.resolveValue("minor");
            Object micro = obj.resolveValue("micro");
            if (major instanceof Integer && minor instanceof Integer && micro instanceof Integer) {
                String v2;
                Object q = obj.resolveValue("qualifier");
                if (q instanceof IObject && (v2 = ((IObject)q).getClassSpecificName()) != null && v2.length() > 0) {
                    return major + "." + minor + "." + micro + "." + v2;
                }
                return major + "." + minor + "." + micro;
            }
            return null;
        }
    }

    @Subjects(value={"org.eclipse.swt.graphics.Point", "java.awt.Point"})
    public static class PointResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            Object x = obj.resolveValue("x");
            Object y = obj.resolveValue("y");
            return MessageUtil.format((String)Messages.EclipseNameResolver_Point, (Object[])new Object[]{x, y});
        }
    }

    @Subject(value="org.eclipse.swt.graphics.RGB")
    public static class RGBResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            Integer red = (Integer)obj.resolveValue("red");
            Integer green = (Integer)obj.resolveValue("green");
            Integer blue = (Integer)obj.resolveValue("blue");
            if (red == null || green == null || blue == null) {
                return null;
            }
            return MessageUtil.format((String)Messages.EclipseNameResolver_RGB, (Object[])new Object[]{red, green, blue});
        }
    }

    @Subjects(value={"org.eclipse.swt.graphics.Rectangle", "java.awt.Rectangle"})
    public static class RectangleResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            Object x = obj.resolveValue("x");
            Object y = obj.resolveValue("y");
            Object width = obj.resolveValue("width");
            Object height = obj.resolveValue("height");
            return MessageUtil.format((String)Messages.EclipseNameResolver_Rectangle, (Object[])new Object[]{x, y, width, height});
        }
    }

    @Subject(value="org.eclipse.equinox.launcher.Main$StartupClassLoader")
    public static class StartupClassLoaderResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            return Messages.EclipseNameResolver_EquinoxStartupClassLoader;
        }
    }
}

