/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="primitive_arrays_with_a_constant_value")
@Icon(value="/META-INF/icons/constant_value.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
@Subjects(value={"byte[]", "boolean[]", "short[]", "char[]", "int[]", "float[]", "long[]", "double[]"})
public class PrimitiveArraysWithAConstantValueQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    @Help(value="The array objects. Only primitive arrays will be examined.")
    public IHeapObjectArgument objects;

    public IResult execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "DTFJ-PHD");
        listener.subTask(Messages.PrimitiveArraysWithAConstantValueQuery_SearchingArrayValues);
        Quantize.Builder builder = Quantize.valueDistribution((Column[])new Column[]{new Column(Messages.PrimitiveArraysWithAConstantValueQuery_Column_Length, Integer.TYPE).noTotals(), new Column(Messages.PrimitiveArraysWithAConstantValueQuery_Column_Value, Comparable.class).noTotals()});
        builder.column(Messages.PrimitiveArraysWithAConstantValueQuery_Column_NumObjects, Quantize.COUNT);
        builder.column(Messages.Column_ShallowHeap, Quantize.SUM_BYTES, Column.SortDirection.DESC);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        int counter = 0;
        IClass type = null;
        for (int[] objectIds : this.objects) {
            int objectId;
            HashMapIntObject resultMap = null;
            int[] sortedObjs = objectIds;
            int prev = Integer.MIN_VALUE;
            int[] nArray = objectIds;
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                objectId = nArray[n2];
                if (objectId < prev) {
                    sortedObjs = (int[])objectIds.clone();
                    Arrays.sort(sortedObjs);
                    resultMap = new HashMapIntObject();
                    break;
                }
                prev = objectId;
                ++n2;
            }
            nArray = sortedObjs;
            n = sortedObjs.length;
            n2 = 0;
            while (n2 < n) {
                IObject obj;
                objectId = nArray[n2];
                if (listener.isCanceled()) break;
                if (this.snapshot.isArray(objectId) && !((obj = this.snapshot.getObject(objectId)) instanceof IObjectArray)) {
                    IPrimitiveArray array;
                    int length;
                    if (counter++ % 1000 == 0 && !obj.getClazz().equals(type)) {
                        type = obj.getClazz();
                        listener.subTask(String.valueOf(Messages.PrimitiveArraysWithAConstantValueQuery_SearchingArrayValues) + "\n" + type.getName());
                    }
                    if ((length = (array = (IPrimitiveArray)obj).getLength()) > 1) {
                        int BUFSIZE = 16384;
                        boolean allSame = true;
                        Object value0 = null;
                        int i = 0;
                        block3: while (allSame && i < length) {
                            int j;
                            int buflen = Math.min(length - i, 16384);
                            Object o = array.getValueArray(i, buflen);
                            if (i == 0) {
                                value0 = Array.get(objectIds, 0);
                                j = 1;
                            } else {
                                j = 0;
                            }
                            int actlen = Array.getLength(o);
                            i += actlen;
                            while (j < actlen) {
                                Object valueAt = Array.get(o, j);
                                if (!valueAt.equals(value0)) {
                                    allSame = false;
                                    continue block3;
                                }
                                ++j;
                            }
                        }
                        if (allSame) {
                            long size = this.snapshot.getHeapSize(objectId);
                            if (resultMap != null) {
                                resultMap.put(objectId, (Object)new Result(length, value0, size));
                            } else {
                                quantize.addValue(objectId, new Object[]{length, value0, null, size});
                            }
                        }
                    }
                }
                ++n2;
            }
            if (resultMap != null) {
                nArray = objectIds;
                n = objectIds.length;
                n2 = 0;
                while (n2 < n) {
                    objectId = nArray[n2];
                    if (resultMap.containsKey(objectId)) {
                        Result r = (Result)resultMap.get(objectId);
                        quantize.addValue(objectId, new Object[]{r.len, r.value, null, r.used});
                    }
                    ++n2;
                }
            }
            if (listener.isCanceled()) break;
        }
        return quantize.getResult();
    }

    private static class Result {
        final int len;
        final Object value;
        final long used;

        public Result(int len, Object value, long used) {
            this.len = len;
            this.value = value;
            this.used = used;
        }
    }
}

