/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ExcludedReferencesDescriptor;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

@CommandName(value="customized_retained_set")
@Icon(value="/META-INF/icons/show_retained_set.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/concepts/shallowretainedheap.html")
public class CustomizedRetainedSetQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false, flag="x")
    public String[] excludedReferences;
    @Argument(isMandatory=false, flag="xfile")
    public File excludedReferencesListFile;

    public IResult execute(IProgressListener listener) throws Exception {
        int[] retainedSet;
        SimpleMonitor monitor = new SimpleMonitor(MessageUtil.format((String)Messages.CustomizedRetainedSetQuery_QueryName, (Object[])new Object[]{this.objects.getLabel()}), listener, new int[]{10, 950, 50});
        if (this.excludedReferences == null && this.excludedReferencesListFile == null) {
            int[] objs = this.objects.getIds(monitor.nextMonitor());
            retainedSet = this.snapshot.getRetainedSet(objs, monitor.nextMonitor());
        } else {
            String[] fromFile = this.getLinesFromFile();
            if (fromFile != null && fromFile.length > 0) {
                if (this.excludedReferences != null) {
                    String[] tmp = new String[fromFile.length + this.excludedReferences.length];
                    System.arraycopy(fromFile, 0, tmp, 0, fromFile.length);
                    System.arraycopy(this.excludedReferences, 0, tmp, fromFile.length, this.excludedReferences.length);
                    this.excludedReferences = tmp;
                } else {
                    this.excludedReferences = fromFile;
                }
            }
            ExcludedReferencesDescriptor[] excludedRefDescriptors = this.getExcludedReferenceDescriptors(this.excludedReferences);
            int[] objs = this.objects.getIds(monitor.nextMonitor());
            retainedSet = this.snapshot.getRetainedSet(objs, excludedRefDescriptors, monitor.nextMonitor());
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        Histogram histogram = this.snapshot.getHistogram(retainedSet, monitor.nextMonitor());
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram.setLabel(MessageUtil.format((String)Messages.CustomizedRetainedSetQuery_RetainedBy, (Object[])new Object[]{this.objects.getLabel()}));
        listener.done();
        return histogram;
    }

    private ExcludedReferencesDescriptor[] getExcludedReferenceDescriptors(String[] excludedRefs) throws SnapshotException {
        ExcludedReferencesDescriptor[] result = new ExcludedReferencesDescriptor[excludedRefs.length];
        int i = 0;
        String[] stringArray = excludedRefs;
        int n = excludedRefs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            StringTokenizer tokenizer = new StringTokenizer(s, ":");
            String objectsDescription = tokenizer.nextToken();
            ArrayIntBig objectIds = new ArrayIntBig();
            if (objectsDescription.startsWith("0x")) {
                long objAddress = Long.parseLong(objectsDescription.substring(2), 16);
                objectIds.add(this.snapshot.mapAddressToId(objAddress));
            } else {
                Collection<IClass> classes = this.snapshot.getClassesByName(objectsDescription, true);
                if (classes != null) {
                    for (IClass clazz : classes) {
                        objectIds.addAll(clazz.getObjectIds());
                    }
                }
            }
            HashSet<String> fields = null;
            if (tokenizer.hasMoreTokens()) {
                fields = new HashSet<String>();
                StringTokenizer fieldTokenizer = new StringTokenizer(tokenizer.nextToken(), ",");
                while (fieldTokenizer.hasMoreTokens()) {
                    fields.add(fieldTokenizer.nextToken());
                }
            }
            ExcludedReferencesDescriptor desc = new ExcludedReferencesDescriptor(objectIds.toArray(), fields);
            result[i++] = desc;
            ++n2;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getLinesFromFile() throws IOException {
        Charset cs;
        if (this.excludedReferencesListFile == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            String encoding = ResourcesPlugin.getEncoding();
            cs = encoding != null ? Charset.forName(encoding) : StandardCharsets.UTF_8;
        }
        catch (UnsupportedCharsetException e) {
            cs = StandardCharsets.UTF_8;
        }
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            FileInputStream fis = new FileInputStream(this.excludedReferencesListFile);
            try {
                block22: {
                    InputStreamReader isr = new InputStreamReader((InputStream)fis, cs);
                    try {
                        try (BufferedReader in = new BufferedReader(isr);){
                            String line = null;
                            while ((line = in.readLine()) != null) {
                                result.add(line);
                            }
                        }
                        if (isr == null) break block22;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (isr == null) throw throwable;
                        isr.close();
                        throw throwable;
                    }
                    isr.close();
                }
                if (fis == null) return result.toArray(new String[result.size()]);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return result.toArray(new String[result.size()]);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }
}

