/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.core.java;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.lsp4jakarta.jdt.internal.core.java.codeaction.JavaCodeActionDefinition;
import org.eclipse.lsp4jakarta.jdt.internal.core.java.completion.JavaCompletionDefinition;
import org.eclipse.lsp4jakarta.jdt.internal.core.java.diagnostics.JavaDiagnosticsDefinition;

public class JavaFeaturesRegistry {
    private static final String EXTENSION_JAVA_FEATURE_PARTICIPANTS = "javaFeatureParticipants";
    private static final String CODEACTION_ELT = "codeAction";
    private static final String COMPLETION_ELT = "completion";
    private static final String DIAGNOSTICS_ELT = "diagnostics";
    private static final Logger LOGGER = Logger.getLogger(JavaFeaturesRegistry.class.getName());
    private static final JavaFeaturesRegistry INSTANCE = new JavaFeaturesRegistry();
    private final List<JavaCompletionDefinition> javaCompletionDefinitions = new ArrayList<JavaCompletionDefinition>();
    private final List<JavaDiagnosticsDefinition> javaDiagnosticsDefinitions = new ArrayList<JavaDiagnosticsDefinition>();
    private final List<JavaCodeActionDefinition> javaCodeActionDefinitions = new ArrayList<JavaCodeActionDefinition>();
    private boolean javaFeatureDefinitionsLoaded = false;

    public static JavaFeaturesRegistry getInstance() {
        return INSTANCE;
    }

    public List<JavaCompletionDefinition> getJavaCompletionDefinitions() {
        this.loadJavaFeatureDefinitions();
        return this.javaCompletionDefinitions;
    }

    private synchronized void loadJavaFeatureDefinitions() {
        if (this.javaFeatureDefinitionsLoaded) {
            return;
        }
        this.javaFeatureDefinitionsLoaded = true;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.lsp4jakarta.jdt.core", EXTENSION_JAVA_FEATURE_PARTICIPANTS);
        this.addJavaFeatureDefinition(cf);
    }

    private void addJavaFeatureDefinition(IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                this.createAndAddDefinition(ce);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "Error while collecting java features extension contributions", t);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndAddDefinition(IConfigurationElement ce) throws CoreException {
        switch (ce.getName()) {
            case "codeAction": {
                JavaCodeActionDefinition definition = new JavaCodeActionDefinition(ce);
                List<JavaCodeActionDefinition> list = this.javaCodeActionDefinitions;
                synchronized (list) {
                    this.javaCodeActionDefinitions.add(definition);
                    break;
                }
            }
            case "completion": {
                JavaCompletionDefinition definition = new JavaCompletionDefinition(ce);
                List<JavaCompletionDefinition> list = this.javaCompletionDefinitions;
                synchronized (list) {
                    this.javaCompletionDefinitions.add(definition);
                    break;
                }
            }
            case "diagnostics": {
                JavaDiagnosticsDefinition definition = new JavaDiagnosticsDefinition(ce);
                List<JavaDiagnosticsDefinition> list = this.javaDiagnosticsDefinitions;
                synchronized (list) {
                    this.javaDiagnosticsDefinitions.add(definition);
                    break;
                }
            }
        }
    }

    public List<JavaDiagnosticsDefinition> getJavaDiagnosticsDefinitions() {
        this.loadJavaFeatureDefinitions();
        return this.javaDiagnosticsDefinitions;
    }

    public List<JavaCodeActionDefinition> getJavaCodeActionDefinitions(String codeActionKind) {
        this.loadJavaFeatureDefinitions();
        return this.javaCodeActionDefinitions.stream().filter(definition -> codeActionKind.startsWith(definition.getKind())).collect(Collectors.toList());
    }
}

