/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.tests.mock;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class MockConnectionProvider
implements StreamConnectionProvider {
    private InputStream clientInputStream;
    private OutputStream clientOutputStream;
    private InputStream errorStream;
    private Future<Void> listener;
    private Collection<Closeable> streams = new ArrayList<Closeable>(4);
    private static ExecutorService testRunner = Executors.newCachedThreadPool();
    public static final Collection<Message> cancellations = new ArrayList<Message>();

    public void start() throws IOException {
        Pipe serverOutputToClientInput = Pipe.open();
        Pipe clientOutputToServerInput = Pipe.open();
        this.errorStream = InputStream.nullInputStream();
        InputStream serverInputStream = Channels.newInputStream(clientOutputToServerInput.source());
        OutputStream serverOutputStream = Channels.newOutputStream(serverOutputToClientInput.sink());
        Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)MockLanguageServer.INSTANCE, (InputStream)serverInputStream, (OutputStream)serverOutputStream, (ExecutorService)testRunner, Function.identity());
        this.clientInputStream = Channels.newInputStream(serverOutputToClientInput.source());
        this.clientOutputStream = Channels.newOutputStream(clientOutputToServerInput.sink());
        this.listener = launcher.startListening();
        MockLanguageServer.INSTANCE.addRemoteProxy((LanguageClient)launcher.getRemoteProxy());
        this.streams.add(this.clientOutputStream);
        this.streams.add(serverOutputStream);
        this.streams.add(this.errorStream);
    }

    public InputStream getInputStream() {
        return this.clientInputStream;
    }

    public OutputStream getOutputStream() {
        return this.clientOutputStream;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public void stop() {
        this.streams.forEach(t -> {
            try {
                t.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.streams.clear();
        this.listener.cancel(true);
        this.listener = null;
    }

    public void handleMessage(Message message, LanguageServer languageServer, @Nullable URI rootURI) {
        if (message.toString().contains("cancelRequest")) {
            cancellations.add(message);
        }
        super.handleMessage(message, languageServer, rootURI);
    }
}

