/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.services.LanguageServer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StreamConnectionProviderTest {
    private static StreamConnectionProvider newProvider() {
        return new StreamConnectionProvider(){

            public void start() throws IOException {
            }

            public InputStream getInputStream() {
                return null;
            }

            public OutputStream getOutputStream() {
                return null;
            }

            public InputStream getErrorStream() {
                return null;
            }

            public void stop() {
            }

            public void handleMessage(Message message, LanguageServer languageServer, URI rootURI) {
            }
        };
    }

    @Test
    public void test_forwardCopy_singleByteRead_writesToProvidedOutput() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream("ABC".getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream forwarding = StreamConnectionProviderTest.newProvider().forwardCopyTo((InputStream)input, (OutputStream)sink);){
            while (forwarding.read() != -1) {
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assertions.assertEquals((Object)"ABC", (Object)sink.toString(StandardCharsets.UTF_8), (String)"expected input to be forwarded to provided OutputStream");
    }

    @Test
    public void test_forwardCopy_readArray_onEOF_returnsMinusOne_noException() throws Exception {
        ByteArrayInputStream emptyInput = new ByteArrayInputStream(new byte[0]);
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream forwarding = StreamConnectionProviderTest.newProvider().forwardCopyTo((InputStream)emptyInput, (OutputStream)sink);){
            byte[] buf = new byte[8];
            int n = forwarding.read(buf);
            Assertions.assertEquals((int)-1, (int)n, (String)"expected EOF (-1) on empty stream");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])sink.toByteArray());
    }
}

