/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.VersionedEdits;
import org.eclipse.lsp4e.internal.DocumentUtil;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class VersioningSupportTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("VersioningSupportTest" + System.currentTimeMillis());
    }

    @Test
    public void testVersionSupportSuccess() throws Exception {
        ArrayList<TextEdit> formattingTextEdits = new ArrayList<TextEdit>();
        formattingTextEdits.add(new TextEdit(new Range(new Position(0, 0), new Position(0, 1)), "MyF"));
        formattingTextEdits.add(new TextEdit(new Range(new Position(0, 10), new Position(0, 11)), ""));
        formattingTextEdits.add(new TextEdit(new Range(new Position(0, 21), new Position(0, 21)), " Second"));
        MockLanguageServer.INSTANCE.setFormattingTextEdits(formattingTextEdits);
        IFile file = TestUtils.createUniqueTestFile(this.project, "Formatting Other Text");
        IEditorPart editor = TestUtils.openEditor(file);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        IDocument doc = viewer.getDocument();
        TextDocumentIdentifier docId = LSPEclipseUtils.toTextDocumentIdentifier((IDocument)doc);
        DocumentFormattingParams params = new DocumentFormattingParams();
        params.setTextDocument(docId);
        params.setOptions(new FormattingOptions(4, true));
        LanguageServers.LanguageServerDocumentExecutor ex = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)doc).withCapability(ServerCapabilities::getDocumentFormattingProvider);
        long modificationStamp = DocumentUtil.getDocumentModificationStamp((IDocument)doc);
        CompletableFuture result = ex.computeFirst(ls -> ls.getTextDocumentService().formatting(params).thenApply(edits -> new VersionedEdits(modificationStamp, edits, doc)));
        VersionedEdits edits = (VersionedEdits)((Optional)result.join()).get();
        editor.getSite().getShell().getDisplay().syncExec(() -> {
            try {
                edits.apply();
            }
            catch (ConcurrentModificationException | BadLocationException e) {
                Assert.fail((String)e.getMessage());
            }
        });
        TestUtils.closeEditor(editor, false);
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testVersionedEditsFailsOnModification() throws Exception {
        ArrayList<TextEdit> formattingTextEdits = new ArrayList<TextEdit>();
        formattingTextEdits.add(new TextEdit(new Range(new Position(0, 0), new Position(0, 1)), "MyF"));
        formattingTextEdits.add(new TextEdit(new Range(new Position(0, 10), new Position(0, 11)), ""));
        formattingTextEdits.add(new TextEdit(new Range(new Position(0, 21), new Position(0, 21)), " Second"));
        MockLanguageServer.INSTANCE.setFormattingTextEdits(formattingTextEdits);
        IFile file = TestUtils.createUniqueTestFile(this.project, "Formatting Other Text");
        IEditorPart editor = TestUtils.openEditor(file);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        IDocument doc = viewer.getDocument();
        TextDocumentIdentifier docId = LSPEclipseUtils.toTextDocumentIdentifier((IDocument)doc);
        DocumentFormattingParams params = new DocumentFormattingParams();
        params.setTextDocument(docId);
        params.setOptions(new FormattingOptions(4, true));
        LanguageServers.LanguageServerDocumentExecutor ex = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)doc).withCapability(ServerCapabilities::getDocumentFormattingProvider);
        long modificationStamp = DocumentUtil.getDocumentModificationStamp((IDocument)doc);
        CompletableFuture result = ex.computeFirst(ls -> ls.getTextDocumentService().formatting(params).thenApply(edits -> new VersionedEdits(modificationStamp, edits, doc)));
        VersionedEdits edits = (VersionedEdits)((Optional)result.join()).get();
        viewer.getDocument().replace(0, 0, "Hello");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(1));
        edits.apply();
    }
}

