/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.qvto.util.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageTuple {
    private static final String ASSERT = "ASSERT \\[(\\w+)\\] failed at \\([^\\)]+\\) : ";
    private static final String ERRORCODE = "(\\w+)\\|";
    private static final Pattern MSG_PATTERN = Pattern.compile("^(ASSERT \\[(\\w+)\\] failed at \\([^\\)]+\\) : )?((\\w+)\\|)?(.*)$");
    private final String itsAssert;
    private final String itsMessage;
    private final String itsErrorCode;

    public MessageTuple(String aMessage) {
        Matcher matcher = MSG_PATTERN.matcher(aMessage);
        if (matcher.matches()) {
            this.itsAssert = matcher.group(1);
            this.itsErrorCode = matcher.group(4);
            this.itsMessage = matcher.group(5);
        } else {
            this.itsAssert = null;
            this.itsErrorCode = null;
            this.itsMessage = aMessage;
        }
    }

    public String getMessage() {
        return this.itsMessage;
    }

    public boolean isAssert() {
        return this.itsAssert != null;
    }

    public String getAssert() {
        return this.itsAssert;
    }

    public boolean hasErrorCode() {
        return this.itsErrorCode != null;
    }

    public String getErrorCode() {
        return this.itsErrorCode;
    }

    public static void main(String[] args) {
        MessageTuple.print(MSG_PATTERN.matcher("Failed to determine type for Bar:virtual_in1:virtual_in1"));
        MessageTuple.print(MSG_PATTERN.matcher("CODE|Failed to determine type for Bar:virtual_in1:virtual_in1"));
        MessageTuple.print(MSG_PATTERN.matcher("ASSERT [warning] failed at (addW2WBlocks.qvto:90) : Failed to determine type for Bar:virtual_in1:virtual_in1"));
        MessageTuple.print(MSG_PATTERN.matcher("ASSERT [fatal] failed at (addW2WBlocks.qvto:90) : CODE|Failed to determine type for Bar:virtual_in1:virtual_in1"));
    }

    private static void print(Matcher aMatcher) {
        if (!aMatcher.matches()) {
            System.out.println("NoMatch");
        }
        int i = 1;
        while (i <= aMatcher.groupCount()) {
            System.out.println("Group " + i + ": " + aMatcher.group(i));
            ++i;
        }
    }
}

