/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.views;

import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.ui.AlgorithmSelectionDialog;
import org.eclipse.elk.core.ui.LayoutOptionLabelProvider;
import org.eclipse.elk.core.ui.views.LayoutViewPart;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AlgorithmCellEditor
extends DialogCellEditor {
    private final ILabelProvider labelProvider;

    public AlgorithmCellEditor(Composite parent) {
        super(parent);
        LayoutOptionData algorithmOption = LayoutMetaDataService.getInstance().getOptionData(CoreOptions.ALGORITHM.getId());
        this.labelProvider = new LayoutOptionLabelProvider(algorithmOption);
    }

    protected void fireApplyEditorValue() {
        super.fireApplyEditorValue();
        this.fireCancelEditor();
    }

    protected Control createContents(final Composite cell) {
        Control label = super.createContents(cell);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                LayoutViewPart layoutView;
                Object newValue = AlgorithmCellEditor.this.openDialogBox((Control)cell);
                if (newValue != null) {
                    AlgorithmCellEditor.this.markDirty();
                    AlgorithmCellEditor.this.doSetValue(newValue);
                    AlgorithmCellEditor.this.fireApplyEditorValue();
                }
                if ((layoutView = LayoutViewPart.findView()) != null) {
                    layoutView.setFocus();
                }
            }
        });
        return label;
    }

    protected void updateContents(Object value) {
        if (value != null) {
            super.updateContents((Object)this.labelProvider.getText(value));
        }
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        AlgorithmSelectionDialog dialog = new AlgorithmSelectionDialog(cellEditorWindow.getShell(), (String)this.getValue());
        if (dialog.open() == 0) {
            return dialog.getSelectedHint();
        }
        return null;
    }
}

