/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;

public class CifMarkedUtils {
    private CifMarkedUtils() {
    }

    public static Expression getMarked(Specification spec) {
        List<Expression> autMarkeds = CifCollectUtils.getComplexComponentsStream((ComplexComponent)spec).filter(c -> c instanceof Automaton).map(aut -> CifMarkedUtils.getMarked((Automaton)aut)).toList();
        List<Expression> compMarkeds = CifCollectUtils.getComplexComponentsStream((ComplexComponent)spec).flatMap(c -> c.getMarkeds().stream()).map(p -> (Expression)EMFHelper.deepclone((EObject)p)).toList();
        return CifValueUtils.createConjunction(Lists.concat(autMarkeds, compMarkeds), true);
    }

    public static Expression getMarked(Automaton aut) {
        boolean makeConditional = aut.getLocations().size() >= 2;
        List<Expression> locMarkeds = aut.getLocations().stream().map(loc -> CifMarkedUtils.getMarked(loc, makeConditional)).toList();
        return CifValueUtils.createConjunction(locMarkeds, true);
    }

    public static Expression getMarked(Location loc, boolean makeConditional) {
        BoolExpression marked;
        if (loc.getMarkeds().isEmpty()) {
            marked = CifValueUtils.makeFalse();
        } else {
            List<Expression> preds = loc.getMarkeds().stream().map(p -> (Expression)EMFHelper.deepclone((EObject)p)).toList();
            marked = CifValueUtils.createConjunction(preds, true);
        }
        if (makeConditional) {
            LocationExpression locExpr = CifConstructors.newLocationExpression();
            locExpr.setLocation(loc);
            locExpr.setType((CifType)CifConstructors.newBoolType());
            BinaryExpression binExpr = CifConstructors.newBinaryExpression();
            binExpr.setOperator(BinaryOperator.IMPLICATION);
            binExpr.setLeft((Expression)locExpr);
            binExpr.setRight((Expression)marked);
            binExpr.setType((CifType)CifConstructors.newBoolType());
            marked = binExpr;
        }
        return marked;
    }
}

