/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c99;

import java.util.Collection;
import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.CurlyBraceIfElseGenerator;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.FunctionCodeGen;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.c99.C99DataValue;
import org.eclipse.escet.cif.codegen.c99.typeinfos.C99TypeInfoHelper;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.common.CifDocAnnotationUtils;
import org.eclipse.escet.cif.common.FuncLocalVarOrderer;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;

public class C99FunctionCodeGen
extends FunctionCodeGen {
    public final boolean genLocalFunctions;

    public C99FunctionCodeGen(boolean genLocalFunctions, InternalFunction function) {
        super(function);
        this.genLocalFunctions = genLocalFunctions;
    }

    public void generate(CodeBox declCode, CodeBox defCode, CodeContext ctxt) {
        int n;
        Object paramVar;
        int varBase = ctxt.reserveTempVariables();
        int paramCount = this.function.getParameters().size();
        int refParamCount = 0;
        VariableInformation[] paramVars = new VariableInformation[paramCount];
        int i = 0;
        while (i < paramCount) {
            paramVars[i] = ctxt.getWriteVarInfo((Declaration)((FunctionParameter)this.function.getParameters().get(i)).getParameter());
            if (!C99TypeInfoHelper.typeUsesValues(paramVars[i].typeInfo)) {
                ++refParamCount;
            }
            ++i;
        }
        Object localVars = this.function.getVariables();
        localVars = new FuncLocalVarOrderer().computeOrder((Collection)localVars);
        Assert.notNull((Object)localVars);
        VariableInformation[] localVarInfos = new VariableInformation[refParamCount + localVars.size()];
        int localIndex = 0;
        MemoryCodeBox vardeclCode = ctxt.makeCodeBox();
        int i2 = 0;
        while (i2 < paramCount) {
            if (!C99TypeInfoHelper.typeUsesValues(paramVars[i2].typeInfo)) {
                localVarInfos[localIndex] = paramVar = paramVars[i2];
                ++localIndex;
                paramVars[i2] = ctxt.makeTempVariable((VariableInformation)paramVar);
                vardeclCode.add("// Parameter \"%s\".", new Object[]{((VariableInformation)paramVar).name});
                C99DataValue src = C99DataValue.makeReference(paramVars[i2].targetRef);
                Destination dest = new Destination(null, ((VariableInformation)paramVar).typeInfo, C99DataValue.makeValue(((VariableInformation)paramVar).targetRef));
                ((VariableInformation)paramVar).typeInfo.declareInit((CodeBox)vardeclCode, src, dest);
                vardeclCode.add();
            }
            ++i2;
        }
        paramVar = localVars.iterator();
        while (paramVar.hasNext()) {
            VariableInformation localVar;
            DiscVariable var = (DiscVariable)paramVar.next();
            localVarInfos[localIndex] = localVar = ctxt.getWriteVarInfo((Declaration)var);
            ++localIndex;
            vardeclCode.add("// Variable \"%s\".", new Object[]{localVar.name});
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)var);
            for (String doc : docs) {
                vardeclCode.add("//");
                String[] stringArray = doc.split("\\r?\\n");
                int n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String line = stringArray[n];
                    vardeclCode.add("// %s", new Object[]{line});
                    ++n;
                }
            }
            vardeclCode.add("%s %s;", new Object[]{localVar.typeInfo.getTargetType(), localVar.targetRef});
            Destination dest = new Destination(null, localVar.typeInfo, C99DataValue.makeValue(localVar.targetRef));
            Assert.notNull((Object)var.getValue());
            Assert.check((var.getValue().getValues().size() == 1 ? 1 : 0) != 0);
            ExprCode initCode = ctxt.exprToTarget((Expression)var.getValue().getValues().get(0), dest);
            vardeclCode.add((Box)initCode.getCode());
            vardeclCode.add();
        }
        Assert.check((localIndex == localVarInfos.length ? 1 : 0) != 0);
        String origFuncName = ctxt.getOrigFunctionName(this.function);
        if (origFuncName == null) {
            origFuncName = this.function.getName();
        }
        MemoryCodeBox descriptionCode = ctxt.makeCodeBox();
        List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)this.function);
        descriptionCode.add();
        descriptionCode.add("/**");
        descriptionCode.add(" * Function \"%s\".", new Object[]{origFuncName});
        for (String doc : docs) {
            descriptionCode.add(" *");
            String[] stringArray = doc.split("\\r?\\n");
            n = stringArray.length;
            int line = 0;
            while (line < n) {
                String line2 = stringArray[line];
                descriptionCode.add(" * %s", new Object[]{line2});
                ++line;
            }
        }
        descriptionCode.add(" *");
        int i3 = 0;
        while (i3 < paramCount) {
            DiscVariable param = ((FunctionParameter)this.function.getParameters().get(i3)).getParameter();
            VariableInformation varInfo = paramVars[i3];
            descriptionCode.add(" * @param %s Function parameter \"%s\".", new Object[]{varInfo.targetVariableName, varInfo.name});
            List paramDocs = CifDocAnnotationUtils.getDocs((AnnotatedObject)param);
            for (String doc : paramDocs) {
                descriptionCode.add(" *");
                String[] stringArray = doc.split("\\r?\\n");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String line = stringArray[n4];
                    descriptionCode.add(" *     %s", new Object[]{line});
                    ++n4;
                }
            }
            ++i3;
        }
        descriptionCode.add(" * @return The return value of the function.");
        descriptionCode.add(" */");
        declCode.add((Box)descriptionCode);
        defCode.add((Box)descriptionCode);
        TypeInfo returnTi = ctxt.typeToTarget(this.getReturnType());
        StringBuilder fnHeader = new StringBuilder();
        fnHeader.append(returnTi.getTargetType());
        fnHeader.append(" ");
        String funcName = ctxt.getFunctionName(this.function);
        fnHeader.append(funcName);
        fnHeader.append('(');
        int i4 = 0;
        while (i4 < paramCount) {
            if (i4 > 0) {
                fnHeader.append(", ");
            }
            if (C99TypeInfoHelper.typeUsesValues(paramVars[i4].typeInfo)) {
                fnHeader.append(paramVars[i4].typeInfo.getTargetType());
                fnHeader.append(' ');
                fnHeader.append(paramVars[i4].targetRef);
            } else {
                fnHeader.append(paramVars[i4].typeInfo.getTargetType());
                fnHeader.append("* ");
                fnHeader.append(paramVars[i4].targetRef);
            }
            ++i4;
        }
        fnHeader.append(")");
        String header = fnHeader.toString();
        if (this.genLocalFunctions) {
            declCode.add("static %s;", new Object[]{header});
            defCode.add("static " + header + " {");
        } else {
            declCode.add("extern %s;", new Object[]{header});
            defCode.add(header + " {");
        }
        defCode.indent();
        defCode.add((Box)vardeclCode);
        defCode.add("// Execute statements in the function body.");
        this.addFuncStatements((List<FunctionStatement>)this.function.getStatements(), defCode, ctxt);
        defCode.add("assert(0); /* Falling through the end of the function. */");
        defCode.dedent();
        defCode.add("}");
        ctxt.unreserveTempVariables(varBase);
    }

    @Override
    protected IfElseGenerator getIfElseFuncGenerator() {
        return new CurlyBraceIfElseGenerator();
    }

    @Override
    protected void generateBreakFuncStatement(CodeBox code) {
        code.add("break;");
    }

    @Override
    protected void generateContinueFuncStatement(CodeBox code) {
        code.add("continue;");
    }

    @Override
    protected void generateReturnFuncStatement(Expression retValue, CodeBox code, boolean safeScope, CodeContext ctxt) {
        ExprCode retCode = ctxt.exprToTarget(retValue, null);
        CodeBox exprCode = retCode.getCode();
        if (exprCode.isEmpty()) {
            safeScope = true;
        }
        if (!safeScope) {
            ctxt.addUpdatesBeginScope(code);
        }
        code.add((Box)exprCode);
        code.add("return %s;", new Object[]{retCode.getData()});
        if (!safeScope) {
            ctxt.addUpdatesEndScope(code);
        }
    }

    @Override
    protected boolean generateWhileFuncStatement(ExprCode guardCode, CodeBox code, boolean safeScope) {
        if (guardCode.hasCode()) {
            code.add("for (;;) {");
            code.indent();
            code.add((Box)guardCode.getCode());
            code.add("if (%s) break;", new Object[]{guardCode.getData()});
            code.add();
            safeScope = false;
        } else {
            code.add("while (%s) {", new Object[]{guardCode.getData()});
            code.indent();
        }
        return safeScope;
    }

    @Override
    protected void generateEndWhileFuncStatement(CodeBox code) {
        code.dedent();
        code.add("}");
    }
}

