/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks.nonblockingundercontrol;

import com.github.javabdd.BDD;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.bdd.settings.ExplorationStrategy;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeApplyDirection;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeKind;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.bdd.utils.CifBddReachability;
import org.eclipse.escet.cif.controllercheck.checks.ControllerCheckerBddBasedCheck;
import org.eclipse.escet.cif.controllercheck.checks.nonblockingundercontrol.NonBlockingUnderControlCheckConclusion;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class NonBlockingUnderControlCheck
extends ControllerCheckerBddBasedCheck<NonBlockingUnderControlCheckConclusion> {
    public static final String PROPERTY_NAME = "non-blocking under control";

    @Override
    public String getPropertyName() {
        return PROPERTY_NAME;
    }

    @Override
    public NonBlockingUnderControlCheckConclusion performCheck(CifBddSpec cifBddSpec) {
        DebugNormalOutput dbg = cifBddSpec.settings.getDebugOutput();
        Termination termination = cifBddSpec.settings.getTermination();
        dbg.line("Computing the condition for no controllable event to be enabled:");
        dbg.inc();
        BDD notGc = this.computeNotGc(cifBddSpec);
        if (termination.isRequested()) {
            return null;
        }
        dbg.line("Condition under which no controllable event is enabled: %s", new Object[]{BddUtils.bddToStr((BDD)notGc, (CifBddSpec)cifBddSpec)});
        dbg.dec();
        dbg.line();
        dbg.line("Computing the controllable-complete path states:");
        dbg.inc();
        BDD ccp = this.computeCcp(cifBddSpec, notGc);
        if (termination.isRequested()) {
            return null;
        }
        dbg.line();
        dbg.line("Controllable-complete path states: %s", new Object[]{BddUtils.bddToStr((BDD)ccp, (CifBddSpec)cifBddSpec)});
        dbg.dec();
        dbg.line();
        dbg.line("Computing the bad states:");
        dbg.inc();
        BDD bad = this.computeBad(cifBddSpec, ccp);
        if (termination.isRequested()) {
            return null;
        }
        dbg.line();
        dbg.line("Bad states: %s", new Object[]{BddUtils.bddToStr((BDD)bad, (CifBddSpec)cifBddSpec)});
        dbg.dec();
        dbg.line();
        dbg.line("Computing the result of the non-blocking under control check:");
        dbg.inc();
        BDD initialAndBad = cifBddSpec.initial.id().andWith(bad);
        if (termination.isRequested()) {
            return null;
        }
        dbg.line("Initial states: %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initial, (CifBddSpec)cifBddSpec)});
        dbg.line("Bad initial states: %s", new Object[]{BddUtils.bddToStr((BDD)initialAndBad, (CifBddSpec)cifBddSpec)});
        dbg.dec();
        boolean isNonBlockingUnderControl = initialAndBad.isZero();
        initialAndBad.free();
        dbg.line();
        dbg.line("Non-blocking under control: %s", new Object[]{isNonBlockingUnderControl ? "yes" : "no"});
        return new NonBlockingUnderControlCheckConclusion(isNonBlockingUnderControl);
    }

    private BDD computeNotGc(CifBddSpec cifBddSpec) {
        Termination termination = cifBddSpec.settings.getTermination();
        BDD gc = cifBddSpec.factory.zero();
        for (CifBddEdge edge : cifBddSpec.edges) {
            if (!edge.event.getControllable().booleanValue()) continue;
            gc = gc.orWith(edge.guard.id());
            if (!termination.isRequested()) continue;
            return null;
        }
        BDD notGc = gc.not();
        gc.free();
        return notGc;
    }

    private BDD computeCcp(CifBddSpec cifBddSpec, BDD notGc) {
        Termination termination = cifBddSpec.settings.getTermination();
        List<CifBddEdge> unctrlEdges = cifBddSpec.edges.stream().filter(e -> e.event.getControllable() == false).toList();
        Map unctrlEdgeGuards = Maps.mapc((int)unctrlEdges.size());
        for (CifBddEdge unctrlEdge : unctrlEdges) {
            unctrlEdgeGuards.put(unctrlEdge, unctrlEdge.guard);
        }
        if (termination.isRequested()) {
            return null;
        }
        for (CifBddEdge unctrlEdge : unctrlEdges) {
            unctrlEdge.guard = unctrlEdge.guard.and(notGc);
            if (termination.isRequested()) {
                return null;
            }
            unctrlEdge.reinitApply();
            if (!termination.isRequested()) continue;
            return null;
        }
        String predName = "controllable-complete path states";
        String initValName = "controllable-complete path end states";
        String restrictionName = null;
        BDD restriction = null;
        CifBddEdgeApplyDirection direction = CifBddEdgeApplyDirection.BACKWARD;
        EnumSet<CifBddEdgeKind> edgeKinds = EnumSet.allOf(CifBddEdgeKind.class);
        boolean dbgEnabled = cifBddSpec.settings.getDebugOutput().isEnabled();
        CifBddReachability reachability = new CifBddReachability(cifBddSpec, predName, initValName, restrictionName, restriction, direction, edgeKinds, dbgEnabled);
        if (cifBddSpec.settings.getExplorationStrategy() == ExplorationStrategy.SATURATION) {
            reachability.setSaturationInstance(1);
        }
        BDD initPred = cifBddSpec.marked.id().andWith(notGc);
        if (termination.isRequested()) {
            return null;
        }
        BDD reachabilityResult = reachability.performReachability(initPred);
        if (termination.isRequested()) {
            return null;
        }
        for (Map.Entry entry : unctrlEdgeGuards.entrySet()) {
            CifBddEdge edge = (CifBddEdge)entry.getKey();
            edge.guard.free();
            edge.guard = (BDD)entry.getValue();
            if (termination.isRequested()) {
                return null;
            }
            edge.reinitApply();
            if (!termination.isRequested()) continue;
            return null;
        }
        return reachabilityResult;
    }

    private BDD computeBad(CifBddSpec cifBddSpec, BDD ccp) {
        Termination termination = cifBddSpec.settings.getTermination();
        String predName = "bad states";
        String initValName = "not controllable-complete path states";
        String restrictionName = null;
        BDD restriction = null;
        CifBddEdgeApplyDirection direction = CifBddEdgeApplyDirection.BACKWARD;
        EnumSet<CifBddEdgeKind> edgeKinds = EnumSet.allOf(CifBddEdgeKind.class);
        boolean dbgEnabled = cifBddSpec.settings.getDebugOutput().isEnabled();
        CifBddReachability reachability = new CifBddReachability(cifBddSpec, predName, initValName, restrictionName, restriction, direction, edgeKinds, dbgEnabled);
        if (cifBddSpec.settings.getExplorationStrategy() == ExplorationStrategy.SATURATION) {
            reachability.setSaturationInstance(2);
        }
        BDD initPred = ccp.not();
        if (termination.isRequested()) {
            return null;
        }
        ccp.free();
        if (termination.isRequested()) {
            return null;
        }
        BDD reachabilityResult = reachability.performReachability(initPred);
        return reachabilityResult;
    }
}

