/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.jobs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.DockerImageBuildFailedException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.IDockerProgressMessage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.consoles.BuildConsole;
import org.eclipse.linuxtools.internal.docker.ui.jobs.JobMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BuildDockerImageJob
extends Job
implements IDockerProgressHandler {
    private static final String BUILD_IMAGE_JOB_TITLE = "BuildImageJob.title";
    private static final String BUILD_IMAGE_ERROR_MESSAGE = "BuildImageError.msg";
    private static final String DOCKERFILE_LINE_COUNT_ERROR = "ImageBuildError.msg";
    private static final String SKIP_EMPTY_DOCKERFILE = "SkipEmptydockerfile.msg";
    private final IDockerConnection connection;
    private final IPath path;
    private final Map<String, Object> buildOptions;
    private final String dockerfileName;
    private final String repoName;
    private final BuildConsole console;
    private IProgressMonitor progressMonitor;

    public BuildDockerImageJob(IDockerConnection connection, IPath path, String dockerfileName, String repoName, Map<String, Object> buildOptions) {
        super(JobMessages.getString(BUILD_IMAGE_JOB_TITLE));
        this.connection = connection;
        this.path = path;
        this.dockerfileName = dockerfileName;
        this.repoName = repoName;
        this.buildOptions = buildOptions;
        this.console = BuildConsole.findConsole();
    }

    private static boolean verifyPathToDockerfile(IPath pathToDockerfile) {
        File dockerfile = pathToDockerfile.toFile();
        if (!dockerfile.exists() || !dockerfile.canRead()) {
            Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)JobMessages.getString(BUILD_IMAGE_JOB_TITLE), (String)JobMessages.getFormattedString("BuildImageError.missing.dockerfile.msg", dockerfile.getAbsolutePath())));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor progressMonitor) {
        try {
            this.progressMonitor = progressMonitor;
            IPath pathToDockerfile = this.path.append(this.dockerfileName);
            if (BuildDockerImageJob.verifyPathToDockerfile(pathToDockerfile)) {
                int numberOfBuildOperations = BuildDockerImageJob.countLines(pathToDockerfile.toOSString());
                if (numberOfBuildOperations == 0) {
                    Activator.log(Status.warning((String)JobMessages.getString(SKIP_EMPTY_DOCKERFILE)));
                } else {
                    this.console.clearConsole();
                    this.console.activate();
                    this.progressMonitor.beginTask(JobMessages.getString(BUILD_IMAGE_JOB_TITLE), numberOfBuildOperations + 1);
                    if (this.repoName == null) {
                        String name = "dockerfile:" + Long.toHexString(System.currentTimeMillis());
                        ((DockerConnection)this.connection).buildImage(pathToDockerfile.removeLastSegments(1), name, this.dockerfileName, (IDockerProgressHandler)this, this.buildOptions);
                    } else {
                        ((DockerConnection)this.connection).buildImage(pathToDockerfile.removeLastSegments(1), this.repoName, this.dockerfileName, (IDockerProgressHandler)this, this.buildOptions);
                    }
                    this.connection.getImages(true);
                }
            }
        }
        catch (InterruptedException | DockerException e) {
            Display.getDefault().syncExec(() -> BuildDockerImageJob.lambda$run$1((Exception)e));
        }
        finally {
            this.progressMonitor.done();
        }
        return Status.OK_STATUS;
    }

    public void processMessage(IDockerProgressMessage message) throws DockerException {
        if (message.error() != null) {
            this.cancel();
            throw new DockerImageBuildFailedException(message.error());
        }
        String status = message.stream();
        if (status != null && status.startsWith("Successfully built")) {
            this.connection.getImages(true);
        } else if (status != null && status.startsWith("Step")) {
            this.progressMonitor.worked(1);
        }
        this.logMessage(status);
    }

    private void logMessage(String buildMessage) {
        if (this.console != null && buildMessage != null) {
            Display.getDefault().asyncExec(() -> {
                this.console.showConsole();
                try {
                    this.console.write(buildMessage.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    Activator.log(e);
                }
            });
        }
    }

    private static int countLines(String fileName) throws DockerException {
        try {
            int count = 0;
            try (FileInputStream fis = new FileInputStream(fileName);
                 InputStreamReader isr = new InputStreamReader(fis);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("#") || line.trim().isEmpty()) continue;
                    ++count;
                }
            }
            return count;
        }
        catch (IOException e) {
            throw new DockerException(JobMessages.getString(DOCKERFILE_LINE_COUNT_ERROR), (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$run$1(Exception e) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)JobMessages.getString(BUILD_IMAGE_ERROR_MESSAGE), (String)e.getMessage());
    }
}

